#include <iostream>
#include <string.h>
#include <vector>
#include <unistd.h>
#include <stdio.h>
#include "sdks.h"
#include "sdks_media.h"
#include "cJSON.h"

unsigned int m_handle = 0;
static void disconn_cb_func(unsigned int handle, void* p_obj,int type)
{
		printf("*******disconn_cb_func ****** handle[%d] type[%d] \n",handle,type);
}

void facebase_cb(unsigned int handle, void* p_data, int *data_len, void** p_result, void* p_obj)
{
	if ((p_data != NULL) && (p_result != NULL))
	{
		int index = 1;
		char result[1024] = { 0 };
		sprintf(result, "%s", (char*)*p_result);

		FILE  *fp = fopen("./json.txt", "ab+");		
		fprintf(fp, "%s\n", result);
		fflush(fp);
		fclose(fp);

		char pic_name[128] = { 0 };
		char path[32] = {0};
		strcpy(path, "./");
		memset(pic_name, '0', sizeof(pic_name));
		sprintf(pic_name, "%s%d.jpg", path, index);
		FILE  *file = fopen(pic_name, "ab+");
		if (file == NULL) {
			return;
		}
		size_t size = fwrite((char *)(p_data), 1, *data_len, file);
		fclose(file);
		
	}
}
void face_cb(unsigned int handle, void* p_data, int *data_len, void** p_result, void* p_obj)
{
	if ((p_data != NULL) && (p_result != NULL))
	{
		int index = 1;
		char result[1024] = { 0 };
		sprintf(result, "%s", (char*)*p_result);

		FILE  *fp = fopen("./json.txt", "ab+");		
		fprintf(fp, "%s\n", result);
		fflush(fp);
		fclose(fp);

		char pic_name[128] = { 0 };
		char path[32] = {0};
		strcpy(path, "./");
		memset(pic_name, '0', sizeof(pic_name));
		sprintf(pic_name, "%s%d.jpg", path, index);
		FILE  *file = fopen(pic_name, "ab+");
		if (file == NULL) {
			return;
		}
		size_t size = fwrite((char *)(p_data), 1, *data_len, file);
		fclose(file);
	}
}

void stream_cb(unsigned int handle, int stream_id, void* p_data, void* p_obj)
{
	if (p_data != NULL)
	{
		ST_AVFrameData *p_frame = (ST_AVFrameData*)p_data;
		if (p_frame->nESStreamType == 2)
		{
			printf("*** audio data\n");
		}
		printf("**** p_frame->nFrameType = %d\n",p_frame->nFrameType);
	}
}

void talk_cb(unsigned int handle, int stream_id, void* p_data, void* p_obj)
{

}

void alarm_cb(unsigned int handle, void** p_data, void* p_obj)
{
	if (p_data != NULL)
	{
		//
		cJSON *p_json_root = cJSON_Parse((char*)*p_data);
		cJSON* p_json_string1 = cJSON_GetObjectItemEx(p_json_root, "data", cJSON_Object);
		cJSON* p_data_1 = cJSON_GetObjectItemEx(p_json_string1, "dev_ip", cJSON_String);   //
		cJSON* p_data_2 = cJSON_GetObjectItemEx(p_json_string1, "src_type", cJSON_Number);  //
		cJSON* p_data_3 = cJSON_GetObjectItemEx(p_json_string1, "src_id", cJSON_Number);    //
		cJSON* p_data_4 = cJSON_GetObjectItemEx(p_json_string1, "dev_id", cJSON_String);     //
		cJSON* p_data_5 = cJSON_GetObjectItemEx(p_json_string1, "dev_type", cJSON_Number);   //
		cJSON* p_data_6 = cJSON_GetObjectItemEx(p_json_string1, "main_type", cJSON_Number);   //
		cJSON* p_data_7 = cJSON_GetObjectItemEx(p_json_string1, "sub_type", cJSON_Number);    //
		cJSON* p_data_8 = cJSON_GetObjectItemEx(p_json_string1, "alarm_flag", cJSON_Number);  //
		cJSON* p_data_9 = cJSON_GetObjectItemEx(p_json_string1, "time", cJSON_String);        //	
		cJSON* p_json_string2 = cJSON_GetObjectItemEx(p_json_root, "SNPointList", cJSON_Array);
		int size = cJSON_GetArraySize(p_json_string2);
		for (int i = 0;i < size;i++)
		{
			cJSON *item = cJSON_GetArrayItem(p_json_string2, i);
			cJSON* p_SNPointList_1 = cJSON_GetObjectItemEx(item, "X", cJSON_Number);
			cJSON* p_SNPointList_2 = cJSON_GetObjectItemEx(item, "Y", cJSON_Number);
		}
		cJSON_Delete(p_json_root);
	}
}
int npic_num = 1;
void detect_face_cb(unsigned int handle, int stream_id, void** p_result, void* p_pic_data, void* p_obj)
{
	printf("detect_face_cb  %d! \n",detect_face_cb);
	if (p_pic_data != NULL)
	{
		cJSON* p_root = cJSON_Parse((char*)*p_result);
		if (p_root == NULL)
		{
			return;
		}
		cJSON* pic_len = cJSON_GetObjectItemEx(p_root, "PictureLen", cJSON_Number);
		printf("detect_face_cb  %d! \n",pic_len->valueint);
		if (NULL == pic_len)
		{
			return;
		}
		char result[1024] = { 0 };
		sprintf(result, "%s", (char*)*p_result);
		FILE  *fp = fopen("./json.txt", "ab+");
		fprintf(fp, "%s\n", result);
		fflush(fp);
		fclose(fp);

		char* data = (char*)p_pic_data;
		char chTemp[64] = {};
		sprintf(chTemp, "%s%d%s", "./test_pic/", npic_num,".jpg");
		FILE  *file = fopen(chTemp, "wb+");
		if (file == NULL) {
			return;
		}
		size_t size = fwrite(data, 1, pic_len->valueint, file);
		fclose(file);
		npic_num++;
	}
}
void intercom_db_cb(unsigned int db, void*p_obj)
{
	printf("*** in audio\n");
}

unsigned int g_stream_ids = 0;
unsigned int g_stream_id = 0;
static void *test_dev_thread(void *p_param)
{
	int i_time = 0;
	char *p_set_json = NULL;
	while (i_time < 10)
	{
	
		//g_stream_ids = sdks_dev_live_start(m_handle, 1, 1,stream_cb,NULL);
		g_stream_id = sdks_dev_face_detect_start(m_handle, 1, 1, 5, detect_face_cb, NULL); 
		printf("sdks_dev_live_start handle = %d stread_id = %d \n",m_handle,g_stream_id);
		sleep(30);
		int ret = sdks_dev_face_detect_stop(m_handle, g_stream_id);
		printf("-----sdks_dev_face_detect_stop--- ret = %d\n",ret);
		//sdks_dev_live_stop(m_handle, g_stream_ids);
		ret = sdks_dev_json_get_hw_cap(m_handle, &p_set_json);
		printf("-----sdks_dev_json_get_hw_cap--- ret = %d p_set_json = %s \n",ret,p_set_json);
		ret =  sdks_dev_get_con_sta(m_handle);
		printf("-----sdks_dev_get_con_sta--- ret = %d\n",ret);
		for(int i= 0;i<10;i++)
		{
			printf("-----sdks_dev_face_detect_stop--- %d\n",i_time);
			usleep(500 * 1000);
		}
		i_time++;
	}
}

int dev_conn_init(void)
{
 	std::string p_ip = "192.168.2.153";
 	std::string user = "admin";
 	std::string passwd = "admin";
 	const unsigned short port = 30001;

	m_handle = sdks_dev_conn(p_ip.c_str(), port, user.c_str(), passwd.c_str(), disconn_cb_func, NULL);
	//m_handle = sdks_create_login_password_param(p_ip.c_str(), port, user.c_str(), passwd.c_str(), "1271192718@qq.com", NULL);
	//sdks_dev_conn_async(p_ip.c_str(), port, user.c_str(), passwd.c_str(), disconn_cb_func, conn_cb_func, NULL);
	if (m_handle <= 0) {
		printf("**********conn sdk fail!****\n");
	}
	else {
		printf("***********conn sdk success!\n");
	}
	return 1;
}

static void thermal_cb_func(unsigned int handle, int stream_id, void** p_result, void* p_data, void* p_obj)
{
	return;
}

int main()
{
	int chn = 1; //	
	unsigned short port =30001; //

	int ret = 0;
	ret = sdks_dev_init("");
	if (ret != 0)
	{
		return -1;
	}
	
	dev_conn_init();
	char *p_result = NULL;
	char *p_set_json = NULL;
	char *p_param = NULL;
	static int  num = 208;
	long code = 0;
	switch (num)
	{
		case 208:
		{
			//ptz
			ret = sdks_dev_open_ptz(m_handle);
			ret = sdks_dev_ptz_threeDimensionalPos(m_handle, 1, 0, 0, -4);
			printf("ptz ret = %d\n",ret);
			sdks_dev_close_ptz(m_handle);
			break;
		}
		case 207:
		{
			g_stream_ids = sdks_dev_live_start(m_handle, 1, 1,stream_cb,NULL);
			/*ret = sdks_dev_audio_start(m_handle, g_stream_ids);
			printf("g_stream_ids = %d,ret = %d\n",g_stream_ids,ret);
			sdks_open_microphone(m_handle, 0, talk_cb, NULL);
			//ret = sdks_md_talk_start(m_handle,0, intercom_db_cb, NULL);
			if (ret < 0)
			{
				printf("**** talk\n");
			}
			FILE* fp;
			int size = 0;
			fp = fopen("./bcvoice.aud", "r");
			if (fp == NULL) // 
			{
				//assert(0);
			}
			fseek(fp, 0, SEEK_END);
			size = ftell(fp);
			fseek(fp, 0, SEEK_SET);
			char *buffer = (char *)malloc(size + 4);
			memset(buffer, 0, size);

			fread(buffer, 1, size, fp);
			int datalen = 320;
			int num = size / datalen;
			for (int i = 0; i < num; i++)
			{
				char dateAudio[320] = {0};
				memcpy(dateAudio, buffer + i*datalen, datalen);
				ret = sdks_dev_send_audio_data(m_handle, dateAudio, datalen);//for  window
				printf("*** send data datalen = %d,ret = %d\n",datalen,ret);
				if (ret != 0)
				{
					//break;
				}
				usleep(10 * 1000);
			}*/
			//ret = sdks_set_iframe_video(m_handle,g_stream_ids);
			printf("**** i frame ret = %d\n",ret);
			usleep(1000 * 1000);
			//ret = sdks_close_microphone(m_handle, 0);
			ret = sdks_dev_live_stop(m_handle,g_stream_ids);
			break;
		}
		case 206:
		{		
			ret = sdks_get_map_relation(m_handle, 1, &p_result);
			if (ret != 0)
			{
				printf("error ret[%d]",ret);
			}
			
			ret = sdks_set_map_relation(m_handle, p_result);
			if (ret != 0)
			{
				printf("error ret[%d]",ret);
			}
			break;
		}
		case 205:
		{
			//
			ret	=sdks_get_thermal_measurement_parameter(m_handle, 1, &p_result);
			if (ret != 0)
			{
				printf("error ret[%d]",ret);
			}
			ret = sdks_set_thermal_measurement_parameter(m_handle, 1, p_result);
			if (ret != 0)
			{
				printf("error ret[%d]",ret);
			}
			break;
		}
		case 204:
		{
			ret = sdks_get_ai_multi_object_detect_param(m_handle, 1, &p_result);
			if (ret != 0)
			{
				printf("error ret[%d]",ret);
			}
			ret = sdks_set_ai_multi_object_detect_param(m_handle, -1, p_result);
			if (ret != 0)
			{
				printf("error ret[%d]",ret);
			}
			break;
		}
		case 203:
		{
			ret = sdks_get_thermal_one_point_temperature(m_handle, 1, 100, 150, &p_result);
			if (ret != 0)
			{
				printf("error ret[%d]",ret);
			}
			break;
		}
		case 202:
		{
			cJSON *current_params_json = NULL;
			ret = sdks_get_thermal_param(m_handle, 1, &p_result);
			if (0 != ret)
			{
				printf("error \n");
			}
			current_params_json = cJSON_Parse(p_result);
			cJSON* p_unit = cJSON_GetObjectItemEx(current_params_json, "temperature_unit", cJSON_Number);
			if (p_unit->valueint == 1)
			{
				cJSON_SetIntValue(p_unit, 0);
			}
			char *param = cJSON_PrintUnformatted(current_params_json);
			ret = sdks_set_thermal_param(m_handle, 1, param);
			cJSON_Delete(current_params_json);
			break;

		}
		case 201:
		{
			printf("***************\n");
			int stream_face_id = sdks_dev_face_detect_start(m_handle, 1, 1, 5, detect_face_cb, NULL);
			printf("***************\n");
			break;

		}
	case 200:
	{
		pthread_t nthread = 1;
		pthread_create(&nthread,0,test_dev_thread,(void *)NULL);
		break;
	}
	case 1:
	{
		ret = sdks_dev_pb_date_list(m_handle, 1, 1,"2019-10-22", "2019-10-24", &p_result);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_pb_get_rec_list(m_handle, 1,1, "2022-03-13", &p_result);
		if (ret != 0)
		{
			return -1;
		}
		int stream_id = sdks_md_rec_download_start(m_handle, 1, 1, "2019-10-23 17:57:00", "2019-10-23 18:04:00", "E://picture//",NULL);
	/*	
		ret = sdks_md_rec_download_stop(m_handle, stream_id);
		if (ret != 0)
		{
			return -1;
		}*/
		break;
	}
	case 2:
	{
		ret = sdks_dev_start_alarm(m_handle, alarm_cb, NULL);
		if (ret != 0)
		{
			return -1;
		}
		/*ret = sdks_dev_stop_alarm(m_handle);
		if (ret != 0)
		{
			return -1;
		}*/
		break;
	}
	case 3:
	{
		ret = sdks_get_fisheye_ability(m_handle, 1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_get_fisheye_video_layout(m_handle, 1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_get_fisheye_param(m_handle, 1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON *p_json_mode = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_json_mode, "VersionId", 1);
		cJSON_AddNumberToObject(p_json_mode, "FisheyeVideoMode", 0);
		cJSON_AddNumberToObject(p_json_mode, "DewarpMode", 8);
		cJSON_AddItemToObject(p_json_root, "FisheyeDewarpModeParam", p_json_mode);

		cJSON *p_json_mount = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_json_mount, "FisheyeMountType", 1);
		cJSON_AddItemToObject(p_json_root, "FisheyeMountParam", p_json_mount);

		p_param = cJSON_PrintUnformatted(p_json_root);
		cJSON_Delete(p_json_root);
		ret = sdks_set_fisheye_param(m_handle, 1, p_param);
		if (ret != 0)
		{
			return -1;
		}

		break;
	}
	case 4:
	{
		ret = sdks_get_ia_advanced_ability(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_get_ia_advanced_param(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON *p_root = cJSON_CreateArray();
		for (int i = 0;i<1;i++)
		{
			cJSON* p_item = cJSON_CreateObject();
			cJSON* p_AdvancedParam = cJSON_CreateObject();
			cJSON_AddNumberToObject(p_AdvancedParam, "Scene", 0);
			cJSON_AddNumberToObject(p_AdvancedParam, "Hight", 0);
			cJSON_AddNumberToObject(p_AdvancedParam, "Angle", 0);
			cJSON_AddNumberToObject(p_AdvancedParam, "FOV", 0);
			cJSON_AddNumberToObject(p_AdvancedParam, "CameraShake", 0);
			cJSON_AddNumberToObject(p_AdvancedParam, "HighNoise", 0);
			cJSON_AddNumberToObject(p_AdvancedParam, "LowContrast", 0);
			cJSON_AddNumberToObject(p_AdvancedParam, "PeriodMotion", 0);
			cJSON_AddNumberToObject(p_AdvancedParam, "PeriodMotionTime", 15);
			cJSON_AddNumberToObject(p_AdvancedParam, "AlarmInterval", 8);
			cJSON_AddItemToObject(p_item, "AdvancedParam", p_AdvancedParam);

			cJSON* p_IntelligentEvent = cJSON_CreateObject();
			{
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceType", 0);
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceID", 1);
				cJSON_AddStringToObject(p_IntelligentEvent, "SourceName", "");
				cJSON_AddBoolToObject(p_IntelligentEvent, "EnableFlag", 0);//
				cJSON_AddNumberToObject(p_IntelligentEvent, "AlarmInterval", 0);
				cJSON_AddBoolToObject(p_IntelligentEvent, "DrawEnable", 0);//
				cJSON *p_time_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_time = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_time, "WeekDay", j);
					cJSON_AddNumberToObject(p_json_time, "StartTime", 0);
					cJSON_AddNumberToObject(p_json_time, "EndTime", 86400);
					cJSON_AddItemToArray(p_time_list, p_json_time);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "ScheduleTimeList", p_time_list);

				cJSON *p_linkage_list = cJSON_CreateArray();
				{
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmLinkageParamList", p_linkage_list);

				cJSON *p_ptz_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_ptz = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionType", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionID", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZChannelID", 1);
					cJSON_AddItemToArray(p_ptz_list, p_json_ptz);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "PTZActionParamList", p_ptz_list);

				cJSON *p_out_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_out = cJSON_CreateObject();
					cJSON_AddStringToObject(p_json_out, "DeviceId", "");
					cJSON_AddNumberToObject(p_json_out, "AlarmOutId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmOutFlag", 1);
					cJSON_AddNumberToObject(p_json_out, "EventTypeId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmTime", 1);
					cJSON_AddItemToArray(p_out_list, p_json_out);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmOutActionList", p_out_list);

				cJSON *p_record_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_record = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_record, "PreRecordFlag", 1);
					cJSON_AddNumberToObject(p_json_record, "DelayRecordTime", 1);
					cJSON_AddItemToArray(p_record_list, p_json_record);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "RecordActionParamList", p_record_list);
			}
			cJSON_AddItemToObject(p_item, "IntelligentEvent", p_IntelligentEvent);

			cJSON *p_real_list = cJSON_CreateArray();
			for (int j = 0;j<1;j++)
			{
				cJSON *p_json_real = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_json_real, "RealSize", 100);
				cJSON_AddNumberToObject(p_json_real, "SegmentLayType", 0);
				cJSON *p_json_detection = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_json_detection, "LineCrossStartX", 77);
				cJSON_AddNumberToObject(p_json_detection, "LineCrossStartY", 39);
				cJSON_AddNumberToObject(p_json_detection, "LineCrossEndX", 0);
				cJSON_AddNumberToObject(p_json_detection, "LineCrossEndY", 39);
				cJSON_AddItemToObject(p_json_real, "TripWireLine", p_json_detection);
				cJSON_AddItemToArray(p_real_list, p_json_real);
			}
			cJSON_AddItemToObject(p_item, "PixelToRealSizeList", p_real_list);

			cJSON_AddItemToArray(p_root, p_item);
		}
		cJSON_AddItemToObject(p_json_root, "AdvancedParamList", p_root);
		p_param = cJSON_PrintUnformatted(p_json_root);
		cJSON_Delete(p_json_root);
		ret = sdks_set_ia_advanced_param(m_handle, -1, p_param);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 5:   //
	{
		ret = sdks_get_ia_signal_bad_ability(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_get_ia_signal_bad_param(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON *p_root = cJSON_CreateArray();
		for (int i = 0;i<1;i++)
		{
			cJSON* p_item = cJSON_CreateObject();
			cJSON* p_SignalBadParam = cJSON_CreateObject();
			cJSON_AddBoolToObject(p_SignalBadParam, "IsGetDetail", 0);  //
			cJSON_AddItemToObject(p_item, "SignalBadParam", p_SignalBadParam);

			cJSON* p_IntelligentEvent = cJSON_CreateObject();
			{
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceType", 18);
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceID", 1);
				cJSON_AddStringToObject(p_IntelligentEvent, "SourceName", "");
				cJSON_AddBoolToObject(p_IntelligentEvent, "EnableFlag", 0);//
				cJSON_AddNumberToObject(p_IntelligentEvent, "AlarmInterval", 0);
				cJSON_AddBoolToObject(p_IntelligentEvent, "DrawEnable", 0);//
				cJSON *p_time_list = cJSON_CreateArray();
				for (int j = 0;j<7;j++)
				{
					cJSON *p_json_time = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_time, "WeekDay", j);
					cJSON_AddNumberToObject(p_json_time, "StartTime", 0);
					cJSON_AddNumberToObject(p_json_time, "EndTime", 86400);
					cJSON_AddItemToArray(p_time_list, p_json_time);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "ScheduleTimeList", p_time_list);

				cJSON *p_linkage_list = cJSON_CreateArray();
				{
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmLinkageParamList", p_linkage_list);

				cJSON *p_ptz_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_ptz = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionType", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionID", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZChannelID", 1);
					cJSON_AddItemToArray(p_ptz_list, p_json_ptz);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "PTZActionParamList", p_ptz_list);

				cJSON *p_out_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_out = cJSON_CreateObject();
					cJSON_AddStringToObject(p_json_out, "DeviceId", "");
					cJSON_AddNumberToObject(p_json_out, "AlarmOutId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmOutFlag", 1);
					cJSON_AddNumberToObject(p_json_out, "EventTypeId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmTime", 1);
					cJSON_AddItemToArray(p_out_list, p_json_out);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmOutActionList", p_out_list);

				cJSON *p_record_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_record = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_record, "PreRecordFlag", 1);
					cJSON_AddNumberToObject(p_json_record, "DelayRecordTime", 1);
					cJSON_AddItemToArray(p_record_list, p_json_record);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "RecordActionParamList", p_record_list);
			}
			cJSON_AddItemToObject(p_item, "IntelligentEvent", p_IntelligentEvent);

			cJSON_AddItemToArray(p_root, p_item);
		}
		cJSON_AddItemToObject(p_json_root, "SignalBadParamList", p_root);
		p_param = cJSON_PrintUnformatted(p_json_root);
		cJSON_Delete(p_json_root);
		ret = sdks_set_ia_signal_bad_param(m_handle, -1, p_param);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 6:
	{
		ret = sdks_get_ia_legal_parking_ability(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_get_ia_legal_parking_param(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON *p_root = cJSON_CreateArray();
		for (int i = 0;i<1;i++)
		{
			cJSON* p_item = cJSON_CreateObject();
			cJSON* p_NoParkingParam = cJSON_CreateObject();
			cJSON_AddBoolToObject(p_NoParkingParam, "IsGetDetail", 0);  //
			cJSON_AddItemToObject(p_item, "NoParkingParam", p_NoParkingParam);

			cJSON* p_IntelligentEvent = cJSON_CreateObject();
			{
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceType", 17);
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceID", 1);
				cJSON_AddStringToObject(p_IntelligentEvent, "SourceName", "");
				cJSON_AddBoolToObject(p_IntelligentEvent, "EnableFlag", 0);//
				cJSON_AddNumberToObject(p_IntelligentEvent, "AlarmInterval", 0);
				cJSON_AddBoolToObject(p_IntelligentEvent, "DrawEnable", 0);//
				cJSON *p_time_list = cJSON_CreateArray();
				for (int j = 0;j<7;j++)
				{
					cJSON *p_json_time = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_time, "WeekDay", j);
					cJSON_AddNumberToObject(p_json_time, "StartTime", 0);
					cJSON_AddNumberToObject(p_json_time, "EndTime", 86400);
					cJSON_AddItemToArray(p_time_list, p_json_time);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "ScheduleTimeList", p_time_list);

				cJSON *p_linkage_list = cJSON_CreateArray();
				{
					cJSON *p_json_linkage1 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage1, "ActionType", 1);
					cJSON_AddNumberToObject(p_json_linkage1, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage1);
					cJSON *p_json_linkage2 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage2, "ActionType", 2);
					cJSON_AddNumberToObject(p_json_linkage2, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage2);
					cJSON *p_json_linkage3 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage3, "ActionType", 4);
					cJSON_AddNumberToObject(p_json_linkage3, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage3);
					cJSON *p_json_linkage4 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage4, "ActionType", 7);
					cJSON_AddNumberToObject(p_json_linkage4, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage4);
					cJSON *p_json_linkage5 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage5, "ActionType", 3);
					cJSON_AddNumberToObject(p_json_linkage5, "ActionID", 2);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage5);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmLinkageParamList", p_linkage_list);

				cJSON *p_ptz_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_ptz = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionType", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionID", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZChannelID", 1);
					cJSON_AddItemToArray(p_ptz_list, p_json_ptz);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "PTZActionParamList", p_ptz_list);

				cJSON *p_out_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_out = cJSON_CreateObject();
					cJSON_AddStringToObject(p_json_out, "DeviceId", "");
					cJSON_AddNumberToObject(p_json_out, "AlarmOutId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmOutFlag", 1);
					cJSON_AddNumberToObject(p_json_out, "EventTypeId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmTime", 1);
					cJSON_AddItemToArray(p_out_list, p_json_out);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmOutActionList", p_out_list);

				cJSON *p_record_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_record = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_record, "PreRecordFlag", 1);
					cJSON_AddNumberToObject(p_json_record, "DelayRecordTime", 1);
					cJSON_AddItemToArray(p_record_list, p_json_record);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "RecordActionParamList", p_record_list);
			}
			cJSON_AddItemToObject(p_item, "IntelligentEvent", p_IntelligentEvent);

			cJSON *p_proper_list = cJSON_CreateArray();
			for (int j = 0;j<1;j++)
			{
				cJSON *p_json_region = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_json_region, "MinTargetSize", 1111);
				cJSON_AddNumberToObject(p_json_region, "MaxTargetSize", 9999);
				cJSON_AddNumberToObject(p_json_region, "MinTime", 5);

				cJSON *p_area_list = cJSON_CreateArray();
				cJSON* p_item_area1 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area1, "Xval", 0);
				cJSON_AddNumberToObject(p_item_area1, "Yval", 0);
				cJSON_AddItemToArray(p_area_list, p_item_area1);
				cJSON* p_item_area2 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area2, "Xval", 0);
				cJSON_AddNumberToObject(p_item_area2, "Yval", 99.5);
				cJSON_AddItemToArray(p_area_list, p_item_area2);
				cJSON* p_item_area3 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area3, "Xval", 99.5);
				cJSON_AddNumberToObject(p_item_area3, "Yval", 99.5);
				cJSON_AddItemToArray(p_area_list, p_item_area3);
				cJSON* p_item_area4 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area4, "Xval", 99.5);
				cJSON_AddNumberToObject(p_item_area4, "Yval", 0);
				cJSON_AddItemToArray(p_area_list, p_item_area4);
				cJSON_AddItemToObject(p_json_region, "SNPoint", p_area_list);

				cJSON_AddItemToArray(p_proper_list, p_json_region);
			}
			cJSON_AddItemToObject(p_item, "NoParkingRegionParamList", p_proper_list);

			cJSON_AddItemToArray(p_root, p_item);
		}
		cJSON_AddItemToObject(p_json_root, "NoParkingParamList", p_root);
		p_param = cJSON_PrintUnformatted(p_json_root);
		cJSON_Delete(p_json_root);
		ret = sdks_set_ia_legal_parking_param(m_handle, -1, p_param);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 7:
	{
		ret = sdks_get_ia_converse_ability(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_get_ia_converse_param(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON *p_root = cJSON_CreateArray();
		for (int i = 0;i<1;i++)
		{
			cJSON* p_item = cJSON_CreateObject();
			cJSON* p_ConverseParam = cJSON_CreateObject();
			cJSON_AddBoolToObject(p_ConverseParam, "IsGetDetail", 0);  //
			cJSON_AddItemToObject(p_item, "ConverseParam", p_ConverseParam);

			cJSON* p_IntelligentEvent = cJSON_CreateObject();
			{
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceType", 16);
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceID", 1);
				cJSON_AddStringToObject(p_IntelligentEvent, "SourceName", "");
				cJSON_AddBoolToObject(p_IntelligentEvent, "EnableFlag", 0);//
				cJSON_AddNumberToObject(p_IntelligentEvent, "AlarmInterval", 0);
				cJSON_AddBoolToObject(p_IntelligentEvent, "DrawEnable", 0);//
				cJSON *p_time_list = cJSON_CreateArray();
				for (int j = 0;j<7;j++)
				{
					cJSON *p_json_time = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_time, "WeekDay", j);
					cJSON_AddNumberToObject(p_json_time, "StartTime", 0);
					cJSON_AddNumberToObject(p_json_time, "EndTime", 86400);
					cJSON_AddItemToArray(p_time_list, p_json_time);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "ScheduleTimeList", p_time_list);

				cJSON *p_linkage_list = cJSON_CreateArray();
				{
					cJSON *p_json_linkage1 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage1, "ActionType", 1);
					cJSON_AddNumberToObject(p_json_linkage1, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage1);
					cJSON *p_json_linkage2 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage2, "ActionType", 2);
					cJSON_AddNumberToObject(p_json_linkage2, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage2);
					cJSON *p_json_linkage3 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage3, "ActionType", 4);
					cJSON_AddNumberToObject(p_json_linkage3, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage3);
					cJSON *p_json_linkage4 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage4, "ActionType", 7);
					cJSON_AddNumberToObject(p_json_linkage4, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage4);
					cJSON *p_json_linkage5 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage5, "ActionType", 3);
					cJSON_AddNumberToObject(p_json_linkage5, "ActionID", 2);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage5);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmLinkageParamList", p_linkage_list);

				cJSON *p_ptz_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_ptz = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionType", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionID", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZChannelID", 1);
					cJSON_AddItemToArray(p_ptz_list, p_json_ptz);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "PTZActionParamList", p_ptz_list);

				cJSON *p_out_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_out = cJSON_CreateObject();
					cJSON_AddStringToObject(p_json_out, "DeviceId", "");
					cJSON_AddNumberToObject(p_json_out, "AlarmOutId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmOutFlag", 1);
					cJSON_AddNumberToObject(p_json_out, "EventTypeId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmTime", 1);
					cJSON_AddItemToArray(p_out_list, p_json_out);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmOutActionList", p_out_list);

				cJSON *p_record_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_record = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_record, "PreRecordFlag", 1);
					cJSON_AddNumberToObject(p_json_record, "DelayRecordTime", 1);
					cJSON_AddItemToArray(p_record_list, p_json_record);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "RecordActionParamList", p_record_list);
			}
			cJSON_AddItemToObject(p_item, "IntelligentEvent", p_IntelligentEvent);

			cJSON *p_proper_list = cJSON_CreateArray();
			for (int j = 0;j<1;j++)
			{
				cJSON *p_json_region = cJSON_CreateObject();
				cJSON_AddBoolToObject(p_json_region, "TargetTypeConstrain", 0);
				cJSON_AddNumberToObject(p_json_region, "TargetType", 0);
				cJSON_AddBoolToObject(p_json_region, "TargetSizeConstrain", 0);
				cJSON_AddNumberToObject(p_json_region, "MinTargetSize", 1111);
				cJSON_AddNumberToObject(p_json_region, "MaxTargetSize", 9999);
				cJSON_AddNumberToObject(p_json_region, "ConverseAngle", 1);

				cJSON *p_area_list = cJSON_CreateArray();
				cJSON* p_item_area1 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area1, "Xval", 0);
				cJSON_AddNumberToObject(p_item_area1, "Yval", 0);
				cJSON_AddItemToArray(p_area_list, p_item_area1);
				cJSON* p_item_area2 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area2, "Xval", 0);
				cJSON_AddNumberToObject(p_item_area2, "Yval", 99.5);
				cJSON_AddItemToArray(p_area_list, p_item_area2);
				cJSON* p_item_area3 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area3, "Xval", 99.5);
				cJSON_AddNumberToObject(p_item_area3, "Yval", 99.5);
				cJSON_AddItemToArray(p_area_list, p_item_area3);
				cJSON* p_item_area4 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area4, "Xval", 99.5);
				cJSON_AddNumberToObject(p_item_area4, "Yval", 0);
				cJSON_AddItemToArray(p_area_list, p_item_area4);
				cJSON_AddItemToObject(p_json_region, "SNPoint", p_area_list);

				cJSON_AddItemToArray(p_proper_list, p_json_region);
			}
			cJSON_AddItemToObject(p_item, "ConverseRegionParamList", p_proper_list);

			cJSON_AddItemToArray(p_root, p_item);
		}
		cJSON_AddItemToObject(p_json_root, "ConverseParamList", p_root);
		p_param = cJSON_PrintUnformatted(p_json_root);
		cJSON_Delete(p_json_root);
		ret = sdks_set_ia_converse_param(m_handle, -1, p_param);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 8:
	{
		ret = sdks_get_ia_abnormal_speed_ability(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_get_ia_abnormal_speed_param(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON *p_root = cJSON_CreateArray();
		for (int i = 0;i<1;i++)
		{
			cJSON* p_item = cJSON_CreateObject();
			cJSON* p_AbnormalSpeedParam = cJSON_CreateObject();
			cJSON_AddBoolToObject(p_AbnormalSpeedParam, "IsGetDetail", 0);  //
			cJSON_AddItemToObject(p_item, "AbnormalSpeedParam", p_AbnormalSpeedParam);

			cJSON* p_IntelligentEvent = cJSON_CreateObject();
			{
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceType", 15);
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceID", 1);
				cJSON_AddStringToObject(p_IntelligentEvent, "SourceName", "");
				cJSON_AddBoolToObject(p_IntelligentEvent, "EnableFlag", 0);//
				cJSON_AddNumberToObject(p_IntelligentEvent, "AlarmInterval", 0);
				cJSON_AddBoolToObject(p_IntelligentEvent, "DrawEnable", 0);//
				cJSON *p_time_list = cJSON_CreateArray();
				for (int j = 0;j<7;j++)
				{
					cJSON *p_json_time = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_time, "WeekDay", j);
					cJSON_AddNumberToObject(p_json_time, "StartTime", 0);
					cJSON_AddNumberToObject(p_json_time, "EndTime", 86400);
					cJSON_AddItemToArray(p_time_list, p_json_time);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "ScheduleTimeList", p_time_list);

				cJSON *p_linkage_list = cJSON_CreateArray();
				{
					cJSON *p_json_linkage1 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage1, "ActionType", 1);
					cJSON_AddNumberToObject(p_json_linkage1, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage1);
					cJSON *p_json_linkage2 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage2, "ActionType", 2);
					cJSON_AddNumberToObject(p_json_linkage2, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage2);
					cJSON *p_json_linkage3 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage3, "ActionType", 4);
					cJSON_AddNumberToObject(p_json_linkage3, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage3);
					cJSON *p_json_linkage4 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage4, "ActionType", 7);
					cJSON_AddNumberToObject(p_json_linkage4, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage4);
					cJSON *p_json_linkage5 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage5, "ActionType", 3);
					cJSON_AddNumberToObject(p_json_linkage5, "ActionID", 2);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage5);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmLinkageParamList", p_linkage_list);

				cJSON *p_ptz_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_ptz = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionType", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionID", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZChannelID", 1);
					cJSON_AddItemToArray(p_ptz_list, p_json_ptz);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "PTZActionParamList", p_ptz_list);

				cJSON *p_out_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_out = cJSON_CreateObject();
					cJSON_AddStringToObject(p_json_out, "DeviceId", "");
					cJSON_AddNumberToObject(p_json_out, "AlarmOutId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmOutFlag", 1);
					cJSON_AddNumberToObject(p_json_out, "EventTypeId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmTime", 1);
					cJSON_AddItemToArray(p_out_list, p_json_out);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmOutActionList", p_out_list);

				cJSON *p_record_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_record = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_record, "PreRecordFlag", 1);
					cJSON_AddNumberToObject(p_json_record, "DelayRecordTime", 1);
					cJSON_AddItemToArray(p_record_list, p_json_record);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "RecordActionParamList", p_record_list);
			}
			cJSON_AddItemToObject(p_item, "IntelligentEvent", p_IntelligentEvent);

			cJSON *p_proper_list = cJSON_CreateArray();
			for (int j = 0;j<1;j++)
			{
				cJSON *p_json_region = cJSON_CreateObject();
				cJSON_AddBoolToObject(p_json_region, "TargetTypeConstrain", 0);
				cJSON_AddNumberToObject(p_json_region, "TargetType", 0);
				cJSON_AddBoolToObject(p_json_region, "TargetSizeConstrain", 0);
				cJSON_AddNumberToObject(p_json_region, "MinTargetSize", 1111);
				cJSON_AddNumberToObject(p_json_region, "MaxTargetSize", 9999);
				cJSON_AddNumberToObject(p_json_region, "RateLimitingType", 1);
				cJSON_AddNumberToObject(p_json_region, "MinRate", 1);
				cJSON_AddNumberToObject(p_json_region, "MaxRate", 2);

				cJSON *p_area_list = cJSON_CreateArray();
				cJSON* p_item_area1 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area1, "Xval", 0);
				cJSON_AddNumberToObject(p_item_area1, "Yval", 0);
				cJSON_AddItemToArray(p_area_list, p_item_area1);
				cJSON* p_item_area2 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area2, "Xval", 0);
				cJSON_AddNumberToObject(p_item_area2, "Yval", 99.5);
				cJSON_AddItemToArray(p_area_list, p_item_area2);
				cJSON* p_item_area3 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area3, "Xval", 99.5);
				cJSON_AddNumberToObject(p_item_area3, "Yval", 99.5);
				cJSON_AddItemToArray(p_area_list, p_item_area3);
				cJSON* p_item_area4 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area4, "Xval", 99.5);
				cJSON_AddNumberToObject(p_item_area4, "Yval", 0);
				cJSON_AddItemToArray(p_area_list, p_item_area4);
				cJSON_AddItemToObject(p_json_region, "SNPoint", p_area_list);

				cJSON_AddItemToArray(p_proper_list, p_json_region);
			}
			cJSON_AddItemToObject(p_item, "AbnormalSpeedRegionParamList", p_proper_list);

			cJSON_AddItemToArray(p_root, p_item);
		}
		cJSON_AddItemToObject(p_json_root, "AbnormalSpeedParamList", p_root);
		p_param = cJSON_PrintUnformatted(p_json_root);
		cJSON_Delete(p_json_root);
		ret = sdks_set_ia_abnormal_speed_param(m_handle, -1, p_param);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 9:
	{
		ret = sdks_get_ia_object_removed_ability(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_get_ia_object_removed_param(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON *p_root = cJSON_CreateArray();
		for (int i = 0;i<1;i++)
		{
			cJSON* p_item = cJSON_CreateObject();
			cJSON* p_ObjMovedParam = cJSON_CreateObject();
			cJSON_AddBoolToObject(p_ObjMovedParam, "IsGetDetail", 0);  //
			cJSON_AddItemToObject(p_item, "ObjMovedParam", p_ObjMovedParam);

			cJSON* p_IntelligentEvent = cJSON_CreateObject();
			{
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceType", 13);
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceID", 1);
				cJSON_AddStringToObject(p_IntelligentEvent, "SourceName", "");
				cJSON_AddBoolToObject(p_IntelligentEvent, "EnableFlag", 0);//
				cJSON_AddNumberToObject(p_IntelligentEvent, "AlarmInterval", 0);
				cJSON_AddBoolToObject(p_IntelligentEvent, "DrawEnable", 0);//
				cJSON *p_time_list = cJSON_CreateArray();
				for (int j = 0;j<7;j++)
				{
					cJSON *p_json_time = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_time, "WeekDay", j);
					cJSON_AddNumberToObject(p_json_time, "StartTime", 0);
					cJSON_AddNumberToObject(p_json_time, "EndTime", 86400);
					cJSON_AddItemToArray(p_time_list, p_json_time);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "ScheduleTimeList", p_time_list);

				cJSON *p_linkage_list = cJSON_CreateArray();
				{
					cJSON *p_json_linkage1 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage1, "ActionType", 1);
					cJSON_AddNumberToObject(p_json_linkage1, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage1);
					cJSON *p_json_linkage2 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage2, "ActionType", 2);
					cJSON_AddNumberToObject(p_json_linkage2, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage2);
					cJSON *p_json_linkage3 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage3, "ActionType", 4);
					cJSON_AddNumberToObject(p_json_linkage3, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage3);
					cJSON *p_json_linkage4 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage4, "ActionType", 7);
					cJSON_AddNumberToObject(p_json_linkage4, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage4);
					cJSON *p_json_linkage5 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage5, "ActionType", 3);
					cJSON_AddNumberToObject(p_json_linkage5, "ActionID", 2);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage5);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmLinkageParamList", p_linkage_list);

				cJSON *p_ptz_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_ptz = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionType", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionID", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZChannelID", 1);
					cJSON_AddItemToArray(p_ptz_list, p_json_ptz);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "PTZActionParamList", p_ptz_list);

				cJSON *p_out_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_out = cJSON_CreateObject();
					cJSON_AddStringToObject(p_json_out, "DeviceId", "");
					cJSON_AddNumberToObject(p_json_out, "AlarmOutId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmOutFlag", 1);
					cJSON_AddNumberToObject(p_json_out, "EventTypeId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmTime", 1);
					cJSON_AddItemToArray(p_out_list, p_json_out);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmOutActionList", p_out_list);

				cJSON *p_record_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_record = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_record, "PreRecordFlag", 1);
					cJSON_AddNumberToObject(p_json_record, "DelayRecordTime", 1);
					cJSON_AddItemToArray(p_record_list, p_json_record);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "RecordActionParamList", p_record_list);
			}
			cJSON_AddItemToObject(p_item, "IntelligentEvent", p_IntelligentEvent);

			cJSON *p_proper_list = cJSON_CreateArray();
			for (int j = 0;j<1;j++)
			{
				cJSON *p_json_region = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_json_region, "MinTargetSize", 1111);
				cJSON_AddNumberToObject(p_json_region, "MaxTargetSize", 9999);
				cJSON_AddNumberToObject(p_json_region, "MinTime", 5); //

				cJSON *p_area_list = cJSON_CreateArray();
				cJSON* p_item_area1 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area1, "Xval", 0);
				cJSON_AddNumberToObject(p_item_area1, "Yval", 0);
				cJSON_AddItemToArray(p_area_list, p_item_area1);
				cJSON* p_item_area2 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area2, "Xval", 0);
				cJSON_AddNumberToObject(p_item_area2, "Yval", 99.5);
				cJSON_AddItemToArray(p_area_list, p_item_area2);
				cJSON* p_item_area3 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area3, "Xval", 99.5);
				cJSON_AddNumberToObject(p_item_area3, "Yval", 99.5);
				cJSON_AddItemToArray(p_area_list, p_item_area3);
				cJSON* p_item_area4 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area4, "Xval", 99.5);
				cJSON_AddNumberToObject(p_item_area4, "Yval", 0);
				cJSON_AddItemToArray(p_area_list, p_item_area4);
				cJSON_AddItemToObject(p_json_region, "SNPoint", p_area_list);

				cJSON_AddItemToArray(p_proper_list, p_json_region);
			}
			cJSON_AddItemToObject(p_item, "ObjMovedRegionParamList", p_proper_list);

			cJSON_AddItemToArray(p_root, p_item);
		}
		cJSON_AddItemToObject(p_json_root, "ObjMovedParamList", p_root);
		p_param = cJSON_PrintUnformatted(p_json_root);
		cJSON_Delete(p_json_root);
		ret = sdks_set_ia_object_removed_param(m_handle, -1, p_param);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 10:
	{
		ret = sdks_get_ia_object_left_ability(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_get_ia_object_left_param(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON *p_root = cJSON_CreateArray();
		for (int i = 0;i<1;i++)
		{
			cJSON* p_item = cJSON_CreateObject();
			cJSON* p_ObjLeftParam = cJSON_CreateObject();
			cJSON_AddBoolToObject(p_ObjLeftParam, "IsGetDetail", 0);  //
			cJSON_AddItemToObject(p_item, "ObjLeftParam", p_ObjLeftParam);

			cJSON* p_IntelligentEvent = cJSON_CreateObject();
			{
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceType", 13);
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceID", 1);
				cJSON_AddStringToObject(p_IntelligentEvent, "SourceName", "");
				cJSON_AddBoolToObject(p_IntelligentEvent, "EnableFlag", 0);//
				cJSON_AddNumberToObject(p_IntelligentEvent, "AlarmInterval", 0);
				cJSON_AddBoolToObject(p_IntelligentEvent, "DrawEnable", 0);//
				cJSON *p_time_list = cJSON_CreateArray();
				for (int j = 0;j<7;j++)
				{
					cJSON *p_json_time = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_time, "WeekDay", j);
					cJSON_AddNumberToObject(p_json_time, "StartTime", 0);
					cJSON_AddNumberToObject(p_json_time, "EndTime", 86400);
					cJSON_AddItemToArray(p_time_list, p_json_time);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "ScheduleTimeList", p_time_list);

				cJSON *p_linkage_list = cJSON_CreateArray();
				{
					cJSON *p_json_linkage1 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage1, "ActionType", 1);
					cJSON_AddNumberToObject(p_json_linkage1, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage1);
					cJSON *p_json_linkage2 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage2, "ActionType", 2);
					cJSON_AddNumberToObject(p_json_linkage2, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage2);
					cJSON *p_json_linkage3 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage3, "ActionType", 4);
					cJSON_AddNumberToObject(p_json_linkage3, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage3);
					cJSON *p_json_linkage4 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage4, "ActionType", 7);
					cJSON_AddNumberToObject(p_json_linkage4, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage4);
					cJSON *p_json_linkage5 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage5, "ActionType", 3);
					cJSON_AddNumberToObject(p_json_linkage5, "ActionID", 2);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage5);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmLinkageParamList", p_linkage_list);

				cJSON *p_ptz_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_ptz = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionType", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionID", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZChannelID", 1);
					cJSON_AddItemToArray(p_ptz_list, p_json_ptz);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "PTZActionParamList", p_ptz_list);

				cJSON *p_out_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_out = cJSON_CreateObject();
					cJSON_AddStringToObject(p_json_out, "DeviceId", "");
					cJSON_AddNumberToObject(p_json_out, "AlarmOutId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmOutFlag", 1);
					cJSON_AddNumberToObject(p_json_out, "EventTypeId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmTime", 1);
					cJSON_AddItemToArray(p_out_list, p_json_out);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmOutActionList", p_out_list);

				cJSON *p_record_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_record = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_record, "PreRecordFlag", 1);
					cJSON_AddNumberToObject(p_json_record, "DelayRecordTime", 1);
					cJSON_AddItemToArray(p_record_list, p_json_record);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "RecordActionParamList", p_record_list);
			}
			cJSON_AddItemToObject(p_item, "IntelligentEvent", p_IntelligentEvent);

			cJSON *p_proper_list = cJSON_CreateArray();
			for (int j = 0;j<1;j++)
			{
				cJSON *p_json_region = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_json_region, "MinTargetSize", 1111);
				cJSON_AddNumberToObject(p_json_region, "MaxTargetSize", 9999);
				cJSON_AddNumberToObject(p_json_region, "MinTime", 5); //

				cJSON *p_area_list = cJSON_CreateArray();
				cJSON* p_item_area1 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area1, "Xval", 0);
				cJSON_AddNumberToObject(p_item_area1, "Yval", 0);
				cJSON_AddItemToArray(p_area_list, p_item_area1);
				cJSON* p_item_area2 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area2, "Xval", 0);
				cJSON_AddNumberToObject(p_item_area2, "Yval", 99.5);
				cJSON_AddItemToArray(p_area_list, p_item_area2);
				cJSON* p_item_area3 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area3, "Xval", 99.5);
				cJSON_AddNumberToObject(p_item_area3, "Yval", 99.5);
				cJSON_AddItemToArray(p_area_list, p_item_area3);
				cJSON* p_item_area4 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area4, "Xval", 99.5);
				cJSON_AddNumberToObject(p_item_area4, "Yval", 0);
				cJSON_AddItemToArray(p_area_list, p_item_area4);
				cJSON_AddItemToObject(p_json_region, "SNPoint", p_area_list);

				cJSON_AddItemToArray(p_proper_list, p_json_region);
			}
			cJSON_AddItemToObject(p_item, "ObjLeftRegionParamList", p_proper_list);

			cJSON_AddItemToArray(p_root, p_item);
		}
		cJSON_AddItemToObject(p_json_root, "ObjLeftParamList", p_root);
		p_param = cJSON_PrintUnformatted(p_json_root);
		cJSON_Delete(p_json_root);
		ret = sdks_set_ia_object_left_param(m_handle, -1, p_param);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 11:
	{
		ret = sdks_get_ia_multi_loiter_ability(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_get_ia_multi_loiter_param(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON *p_root = cJSON_CreateArray();
		for (int i = 0;i<1;i++)
		{
			cJSON* p_item = cJSON_CreateObject();
			cJSON* p_MultiLoiterParam = cJSON_CreateObject();
			cJSON_AddBoolToObject(p_MultiLoiterParam, "IsGetDetail", 0);  //
			cJSON_AddItemToObject(p_item, "MultiLoiterParam", p_MultiLoiterParam);

			cJSON* p_IntelligentEvent = cJSON_CreateObject();
			{
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceType", 12);
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceID", 1);
				cJSON_AddStringToObject(p_IntelligentEvent, "SourceName", "");
				cJSON_AddBoolToObject(p_IntelligentEvent, "EnableFlag", 0);//
				cJSON_AddNumberToObject(p_IntelligentEvent, "AlarmInterval", 0);
				cJSON_AddBoolToObject(p_IntelligentEvent, "DrawEnable", 0);//
				cJSON *p_time_list = cJSON_CreateArray();
				for (int j = 0;j<7;j++)
				{
					cJSON *p_json_time = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_time, "WeekDay", j);
					cJSON_AddNumberToObject(p_json_time, "StartTime", 0);
					cJSON_AddNumberToObject(p_json_time, "EndTime", 86400);
					cJSON_AddItemToArray(p_time_list, p_json_time);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "ScheduleTimeList", p_time_list);

				cJSON *p_linkage_list = cJSON_CreateArray();
				{
					cJSON *p_json_linkage1 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage1, "ActionType", 1);
					cJSON_AddNumberToObject(p_json_linkage1, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage1);
					cJSON *p_json_linkage2 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage2, "ActionType", 2);
					cJSON_AddNumberToObject(p_json_linkage2, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage2);
					cJSON *p_json_linkage3 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage3, "ActionType", 4);
					cJSON_AddNumberToObject(p_json_linkage3, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage3);
					cJSON *p_json_linkage4 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage4, "ActionType", 7);
					cJSON_AddNumberToObject(p_json_linkage4, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage4);
					cJSON *p_json_linkage5 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage5, "ActionType", 3);
					cJSON_AddNumberToObject(p_json_linkage5, "ActionID", 2);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage5);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmLinkageParamList", p_linkage_list);

				cJSON *p_ptz_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_ptz = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionType", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionID", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZChannelID", 1);
					cJSON_AddItemToArray(p_ptz_list, p_json_ptz);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "PTZActionParamList", p_ptz_list);

				cJSON *p_out_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_out = cJSON_CreateObject();
					cJSON_AddStringToObject(p_json_out, "DeviceId", "");
					cJSON_AddNumberToObject(p_json_out, "AlarmOutId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmOutFlag", 1);
					cJSON_AddNumberToObject(p_json_out, "EventTypeId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmTime", 1);
					cJSON_AddItemToArray(p_out_list, p_json_out);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmOutActionList", p_out_list);

				cJSON *p_record_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_record = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_record, "PreRecordFlag", 1);
					cJSON_AddNumberToObject(p_json_record, "DelayRecordTime", 1);
					cJSON_AddItemToArray(p_record_list, p_json_record);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "RecordActionParamList", p_record_list);
			}
			cJSON_AddItemToObject(p_item, "IntelligentEvent", p_IntelligentEvent);

			cJSON *p_proper_list = cJSON_CreateArray();
			for (int j = 0;j<1;j++)
			{
				cJSON *p_json_region = cJSON_CreateObject();
				cJSON_AddBoolToObject(p_json_region, "TargetSizeConstrain", 0);
				cJSON_AddNumberToObject(p_json_region, "MinTargetSize", 1111);
				cJSON_AddNumberToObject(p_json_region, "MaxTargetSize", 9999);
				cJSON_AddNumberToObject(p_json_region, "MinTime", 5); //
				cJSON_AddBoolToObject(p_json_region, "AnalysisPath", 0);
				cJSON_AddBoolToObject(p_json_region, "ForbiddenType", 0);
				cJSON_AddNumberToObject(p_json_region, "Minimum", 1);
				cJSON_AddNumberToObject(p_json_region, "Maximum", 3);

				cJSON *p_area_list = cJSON_CreateArray();
				cJSON* p_item_area1 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area1, "Xval", 0);
				cJSON_AddNumberToObject(p_item_area1, "Yval", 0);
				cJSON_AddItemToArray(p_area_list, p_item_area1);
				cJSON* p_item_area2 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area2, "Xval", 0);
				cJSON_AddNumberToObject(p_item_area2, "Yval", 99.5);
				cJSON_AddItemToArray(p_area_list, p_item_area2);
				cJSON* p_item_area3 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area3, "Xval", 99.5);
				cJSON_AddNumberToObject(p_item_area3, "Yval", 99.5);
				cJSON_AddItemToArray(p_area_list, p_item_area3);
				cJSON* p_item_area4 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area4, "Xval", 99.5);
				cJSON_AddNumberToObject(p_item_area4, "Yval", 0);
				cJSON_AddItemToArray(p_area_list, p_item_area4);
				cJSON_AddItemToObject(p_json_region, "SNPoint", p_area_list);

				cJSON_AddItemToArray(p_proper_list, p_json_region);
			}
			cJSON_AddItemToObject(p_item, "MultiLoiterRegionParamList", p_proper_list);

			cJSON_AddItemToArray(p_root, p_item);
		}
		cJSON_AddItemToObject(p_json_root, "MultiLoiterParamList", p_root);
		p_param = cJSON_PrintUnformatted(p_json_root);
		cJSON_Delete(p_json_root);
		ret = sdks_set_ia_multi_loiter_param(m_handle, -1, p_param);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 12:
	{
		ret = sdks_get_ia_loiter_ability(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_get_ia_loiter_param(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON *p_root = cJSON_CreateArray();
		for (int i = 0;i<1;i++)
		{
			cJSON* p_item = cJSON_CreateObject();
			cJSON* p_LoiterParam = cJSON_CreateObject();
			cJSON_AddBoolToObject(p_LoiterParam, "IsGetDetail", 0);  //
			cJSON_AddItemToObject(p_item, "LoiterParam", p_LoiterParam);

			cJSON* p_IntelligentEvent = cJSON_CreateObject();
			{
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceType", 11);
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceID", 1);
				cJSON_AddStringToObject(p_IntelligentEvent, "SourceName", "");
				cJSON_AddBoolToObject(p_IntelligentEvent, "EnableFlag", 0);//
				cJSON_AddNumberToObject(p_IntelligentEvent, "AlarmInterval", 0);
				cJSON_AddBoolToObject(p_IntelligentEvent, "DrawEnable", 0);//
				cJSON *p_time_list = cJSON_CreateArray();
				for (int j = 0;j<7;j++)
				{
					cJSON *p_json_time = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_time, "WeekDay", j);
					cJSON_AddNumberToObject(p_json_time, "StartTime", 0);
					cJSON_AddNumberToObject(p_json_time, "EndTime", 86400);
					cJSON_AddItemToArray(p_time_list, p_json_time);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "ScheduleTimeList", p_time_list);

				cJSON *p_linkage_list = cJSON_CreateArray();
				{
					cJSON *p_json_linkage1 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage1, "ActionType", 1);
					cJSON_AddNumberToObject(p_json_linkage1, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage1);
					cJSON *p_json_linkage2 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage2, "ActionType", 2);
					cJSON_AddNumberToObject(p_json_linkage2, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage2);
					cJSON *p_json_linkage3 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage3, "ActionType", 4);
					cJSON_AddNumberToObject(p_json_linkage3, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage3);
					cJSON *p_json_linkage4 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage4, "ActionType", 7);
					cJSON_AddNumberToObject(p_json_linkage4, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage4);
					cJSON *p_json_linkage5 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage5, "ActionType", 3);
					cJSON_AddNumberToObject(p_json_linkage5, "ActionID", 2);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage5);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmLinkageParamList", p_linkage_list);

				cJSON *p_ptz_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_ptz = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionType", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionID", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZChannelID", 1);
					cJSON_AddItemToArray(p_ptz_list, p_json_ptz);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "PTZActionParamList", p_ptz_list);

				cJSON *p_out_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_out = cJSON_CreateObject();
					cJSON_AddStringToObject(p_json_out, "DeviceId", "");
					cJSON_AddNumberToObject(p_json_out, "AlarmOutId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmOutFlag", 1);
					cJSON_AddNumberToObject(p_json_out, "EventTypeId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmTime", 1);
					cJSON_AddItemToArray(p_out_list, p_json_out);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmOutActionList", p_out_list);

				cJSON *p_record_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_record = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_record, "PreRecordFlag", 1);
					cJSON_AddNumberToObject(p_json_record, "DelayRecordTime", 1);
					cJSON_AddItemToArray(p_record_list, p_json_record);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "RecordActionParamList", p_record_list);
			}
			cJSON_AddItemToObject(p_item, "IntelligentEvent", p_IntelligentEvent);

			cJSON *p_proper_list = cJSON_CreateArray();
			for (int j = 0;j<1;j++)
			{
				cJSON *p_json_region = cJSON_CreateObject();
				cJSON_AddBoolToObject(p_json_region, "TargetTypeConstrain", 0);
				cJSON_AddNumberToObject(p_json_region, "TargetType", 0);
				cJSON_AddBoolToObject(p_json_region, "TargetSizeConstrain", 0);
				cJSON_AddNumberToObject(p_json_region, "MinTargetSize", 1111);
				cJSON_AddNumberToObject(p_json_region, "MaxTargetSize", 9999);
				cJSON_AddNumberToObject(p_json_region, "MinTime", 5); //
				cJSON_AddBoolToObject(p_json_region, "IsAnalysisPath", 1);

				cJSON *p_area_list = cJSON_CreateArray();
				cJSON* p_item_area1 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area1, "Xval", 0);
				cJSON_AddNumberToObject(p_item_area1, "Yval", 0);
				cJSON_AddItemToArray(p_area_list, p_item_area1);
				cJSON* p_item_area2 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area2, "Xval", 0);
				cJSON_AddNumberToObject(p_item_area2, "Yval", 99.5);
				cJSON_AddItemToArray(p_area_list, p_item_area2);
				cJSON* p_item_area3 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area3, "Xval", 99.5);
				cJSON_AddNumberToObject(p_item_area3, "Yval", 99.5);
				cJSON_AddItemToArray(p_area_list, p_item_area3);
				cJSON* p_item_area4 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area4, "Xval", 99.5);
				cJSON_AddNumberToObject(p_item_area4, "Yval", 0);
				cJSON_AddItemToArray(p_area_list, p_item_area4);
				cJSON_AddItemToObject(p_json_region, "SNPoint", p_area_list);

				cJSON_AddItemToArray(p_proper_list, p_json_region);
			}
			cJSON_AddItemToObject(p_item, "LoiterRegionParamList", p_proper_list);

			cJSON_AddItemToArray(p_root, p_item);
		}
		cJSON_AddItemToObject(p_json_root, "LoiterParamList", p_root);
		p_param = cJSON_PrintUnformatted(p_json_root);
		cJSON_Delete(p_json_root);
		ret = sdks_set_ia_loiter_param(m_handle, -1, p_param);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 13:
	{
		ret = sdks_get_ia_dvf_ability(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_get_ia_dvf_param(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON *p_root = cJSON_CreateArray();
		for (int i = 0;i<1;i++)
		{
			cJSON* p_item = cJSON_CreateObject();
			cJSON* p_MultiTripWireParam = cJSON_CreateObject();
			cJSON_AddBoolToObject(p_MultiTripWireParam, "IsGetDetail", 0);  //
			cJSON_AddItemToObject(p_item, "MultiTripWireParam", p_MultiTripWireParam);

			cJSON* p_IntelligentEvent = cJSON_CreateObject();
			{
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceType", 10);
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceID", 1);
				cJSON_AddStringToObject(p_IntelligentEvent, "SourceName", "");
				cJSON_AddBoolToObject(p_IntelligentEvent, "EnableFlag", 0);//
				cJSON_AddNumberToObject(p_IntelligentEvent, "AlarmInterval", 0);
				cJSON_AddBoolToObject(p_IntelligentEvent, "DrawEnable", 0);//
				cJSON *p_time_list = cJSON_CreateArray();
				for (int j = 0;j<7;j++)
				{
					cJSON *p_json_time = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_time, "WeekDay", j);
					cJSON_AddNumberToObject(p_json_time, "StartTime", 0);
					cJSON_AddNumberToObject(p_json_time, "EndTime", 86400);
					cJSON_AddItemToArray(p_time_list, p_json_time);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "ScheduleTimeList", p_time_list);

				cJSON *p_linkage_list = cJSON_CreateArray();
				{
					cJSON *p_json_linkage1 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage1, "ActionType", 1);
					cJSON_AddNumberToObject(p_json_linkage1, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage1);
					cJSON *p_json_linkage2 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage2, "ActionType", 2);
					cJSON_AddNumberToObject(p_json_linkage2, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage2);
					cJSON *p_json_linkage3 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage3, "ActionType", 4);
					cJSON_AddNumberToObject(p_json_linkage3, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage3);
					cJSON *p_json_linkage4 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage4, "ActionType", 7);
					cJSON_AddNumberToObject(p_json_linkage4, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage4);
					cJSON *p_json_linkage5 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage5, "ActionType", 3);
					cJSON_AddNumberToObject(p_json_linkage5, "ActionID", 2);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage5);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmLinkageParamList", p_linkage_list);

				cJSON *p_ptz_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_ptz = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionType", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionID", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZChannelID", 1);
					cJSON_AddItemToArray(p_ptz_list, p_json_ptz);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "PTZActionParamList", p_ptz_list);

				cJSON *p_out_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_out = cJSON_CreateObject();
					cJSON_AddStringToObject(p_json_out, "DeviceId", "");
					cJSON_AddNumberToObject(p_json_out, "AlarmOutId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmOutFlag", 1);
					cJSON_AddNumberToObject(p_json_out, "EventTypeId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmTime", 1);
					cJSON_AddItemToArray(p_out_list, p_json_out);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmOutActionList", p_out_list);

				cJSON *p_record_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_record = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_record, "PreRecordFlag", 1);
					cJSON_AddNumberToObject(p_json_record, "DelayRecordTime", 1);
					cJSON_AddItemToArray(p_record_list, p_json_record);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "RecordActionParamList", p_record_list);
			}
			cJSON_AddItemToObject(p_item, "IntelligentEvent", p_IntelligentEvent);

			cJSON *p_proper_list = cJSON_CreateArray();
			for (int j = 0;j<1;j++)
			{
				cJSON *p_json_region = cJSON_CreateObject();
				cJSON_AddBoolToObject(p_json_region, "TargetTypeConstrain", 0);
				cJSON_AddNumberToObject(p_json_region, "TargetType", 0);
				cJSON_AddBoolToObject(p_json_region, "TargetSizeConstrain", 0);
				cJSON_AddNumberToObject(p_json_region, "MinTargetSize", 1111);
				cJSON_AddNumberToObject(p_json_region, "MaxTargetSize", 9999);
				cJSON_AddNumberToObject(p_json_region, "TimeInterval", 5);
				cJSON_AddNumberToObject(p_json_region, "TriggerDirection1", 1);
				cJSON_AddNumberToObject(p_json_region, "TriggerDirection2", 2);

				cJSON *p_json_detection1 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_json_detection1, "LineCrossStartX", 24);
				cJSON_AddNumberToObject(p_json_detection1, "LineCrossStartY", 21);
				cJSON_AddNumberToObject(p_json_detection1, "LineCrossEndX", 71);
				cJSON_AddNumberToObject(p_json_detection1, "LineCrossEndY", 25);
				cJSON_AddItemToObject(p_json_region, "LineCross1", p_json_detection1);
				cJSON *p_json_detection2 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_json_detection2, "LineCrossStartX", 26);
				cJSON_AddNumberToObject(p_json_detection2, "LineCrossStartY", 38);
				cJSON_AddNumberToObject(p_json_detection2, "LineCrossEndX", 109);
				cJSON_AddNumberToObject(p_json_detection2, "LineCrossEndY", 46);
				cJSON_AddItemToObject(p_json_region, "LineCross2", p_json_detection2);

				cJSON_AddItemToArray(p_proper_list, p_json_region);
			}
			cJSON_AddItemToObject(p_item, "MultiTripWireRegionParamList", p_proper_list);

			cJSON_AddItemToArray(p_root, p_item);
		}
		cJSON_AddItemToObject(p_json_root, "MultiTripWireParamList", p_root);
		p_param = cJSON_PrintUnformatted(p_json_root);
		cJSON_Delete(p_json_root);
		ret = sdks_set_ia_dvf_param(m_handle, -1, p_param);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 14:
	{
		ret = sdks_get_ia_svf_ability(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_get_ia_svf_param(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON *p_root = cJSON_CreateArray();
		for (int i = 0;i<1;i++)
		{
			cJSON* p_item = cJSON_CreateObject();
			cJSON* p_TripWireParam = cJSON_CreateObject();
			cJSON_AddBoolToObject(p_TripWireParam, "IsGetDetail", 0);  //
			cJSON_AddItemToObject(p_item, "TripWireParam", p_TripWireParam);

			cJSON* p_IntelligentEvent = cJSON_CreateObject();
			{
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceType", 9);
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceID", 1);
				cJSON_AddStringToObject(p_IntelligentEvent, "SourceName", "");
				cJSON_AddBoolToObject(p_IntelligentEvent, "EnableFlag", 0);//
				cJSON_AddNumberToObject(p_IntelligentEvent, "AlarmInterval", 0);
				cJSON_AddBoolToObject(p_IntelligentEvent, "DrawEnable", 0);//
				cJSON *p_time_list = cJSON_CreateArray();
				for (int j = 0;j<7;j++)
				{
					cJSON *p_json_time = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_time, "WeekDay", j);
					cJSON_AddNumberToObject(p_json_time, "StartTime", 0);
					cJSON_AddNumberToObject(p_json_time, "EndTime", 86400);
					cJSON_AddItemToArray(p_time_list, p_json_time);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "ScheduleTimeList", p_time_list);

				cJSON *p_linkage_list = cJSON_CreateArray();
				{
					cJSON *p_json_linkage1 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage1, "ActionType", 1);
					cJSON_AddNumberToObject(p_json_linkage1, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage1);
					cJSON *p_json_linkage2 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage2, "ActionType", 2);
					cJSON_AddNumberToObject(p_json_linkage2, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage2);
					cJSON *p_json_linkage3 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage3, "ActionType", 4);
					cJSON_AddNumberToObject(p_json_linkage3, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage3);
					cJSON *p_json_linkage4 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage4, "ActionType", 7);
					cJSON_AddNumberToObject(p_json_linkage4, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage4);
					cJSON *p_json_linkage5 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage5, "ActionType", 3);
					cJSON_AddNumberToObject(p_json_linkage5, "ActionID", 2);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage5);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmLinkageParamList", p_linkage_list);

				cJSON *p_ptz_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_ptz = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionType", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionID", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZChannelID", 1);
					cJSON_AddItemToArray(p_ptz_list, p_json_ptz);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "PTZActionParamList", p_ptz_list);

				cJSON *p_out_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_out = cJSON_CreateObject();
					cJSON_AddStringToObject(p_json_out, "DeviceId", "");
					cJSON_AddNumberToObject(p_json_out, "AlarmOutId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmOutFlag", 1);
					cJSON_AddNumberToObject(p_json_out, "EventTypeId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmTime", 1);
					cJSON_AddItemToArray(p_out_list, p_json_out);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmOutActionList", p_out_list);

				cJSON *p_record_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_record = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_record, "PreRecordFlag", 1);
					cJSON_AddNumberToObject(p_json_record, "DelayRecordTime", 1);
					cJSON_AddItemToArray(p_record_list, p_json_record);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "RecordActionParamList", p_record_list);
			}
			cJSON_AddItemToObject(p_item, "IntelligentEvent", p_IntelligentEvent);

			cJSON *p_proper_list = cJSON_CreateArray();
			for (int j = 0;j<1;j++)
			{
				cJSON *p_json_region = cJSON_CreateObject();
				cJSON_AddBoolToObject(p_json_region, "TargetTypeConstrain", 0);
				cJSON_AddNumberToObject(p_json_region, "TargetType", 0);
				cJSON_AddBoolToObject(p_json_region, "TargetSizeConstrain", 0);
				cJSON_AddNumberToObject(p_json_region, "MinTargetSize", 1111);
				cJSON_AddNumberToObject(p_json_region, "MaxTargetSize", 9999);
				cJSON_AddBoolToObject(p_json_region, "IsBidirection", 1);
				cJSON_AddNumberToObject(p_json_region, "TriggerDirection", 1);

				cJSON *p_json_detection = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_json_detection, "LineCrossStartX", 24);
				cJSON_AddNumberToObject(p_json_detection, "LineCrossStartY", 21);
				cJSON_AddNumberToObject(p_json_detection, "LineCrossEndX", 71);
				cJSON_AddNumberToObject(p_json_detection, "LineCrossEndY", 25);
				cJSON_AddItemToObject(p_json_region, "TripWireLine", p_json_detection);

				cJSON_AddItemToArray(p_proper_list, p_json_region);
			}
			cJSON_AddItemToObject(p_item, "TripWireRegionParamList", p_proper_list);

			cJSON_AddItemToArray(p_root, p_item);
		}
		cJSON_AddItemToObject(p_json_root, "TripWireParamList", p_root);
		p_param = cJSON_PrintUnformatted(p_json_root);
		cJSON_Delete(p_json_root);
		ret = sdks_set_ia_svf_param(m_handle, -1, p_param);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 15:
	{
		ret = sdks_get_ia_perimeter_ability(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_get_ia_perimeter_param(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON *p_root = cJSON_CreateArray();
		for (int i = 0;i<1;i++)
		{
			cJSON* p_item = cJSON_CreateObject();
			cJSON* p_PerimeterParam = cJSON_CreateObject();
			cJSON_AddBoolToObject(p_PerimeterParam, "IsGetDetail", 0);  //
			cJSON_AddItemToObject(p_item, "PerimeterParam", p_PerimeterParam);

			cJSON* p_IntelligentEvent = cJSON_CreateObject();
			{
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceType", 8);
				cJSON_AddNumberToObject(p_IntelligentEvent, "SourceID", 1);
				cJSON_AddStringToObject(p_IntelligentEvent, "SourceName", "");
				cJSON_AddBoolToObject(p_IntelligentEvent, "EnableFlag", 0);//
				cJSON_AddNumberToObject(p_IntelligentEvent, "AlarmInterval", 0);
				cJSON_AddBoolToObject(p_IntelligentEvent, "DrawEnable", 0);//
				cJSON *p_time_list = cJSON_CreateArray();
				for (int j = 0;j<7;j++)
				{
					cJSON *p_json_time = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_time, "WeekDay", j);
					cJSON_AddNumberToObject(p_json_time, "StartTime", 0);
					cJSON_AddNumberToObject(p_json_time, "EndTime", 86400);
					cJSON_AddItemToArray(p_time_list, p_json_time);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "ScheduleTimeList", p_time_list);

				cJSON *p_linkage_list = cJSON_CreateArray();
				{
					cJSON *p_json_linkage1 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage1, "ActionType", 1);
					cJSON_AddNumberToObject(p_json_linkage1, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage1); //
					cJSON *p_json_linkage2 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage2, "ActionType", 2);
					cJSON_AddNumberToObject(p_json_linkage2, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage2);  //
					cJSON *p_json_linkage3 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage3, "ActionType", 4);
					cJSON_AddNumberToObject(p_json_linkage3, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage3);   //
					cJSON *p_json_linkage4 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage4, "ActionType", 7);
					cJSON_AddNumberToObject(p_json_linkage4, "ActionID", 1);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage4);   //
					cJSON *p_json_linkage5 = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_linkage5, "ActionType", 3);
					cJSON_AddNumberToObject(p_json_linkage5, "ActionID", 2);
					cJSON_AddItemToArray(p_linkage_list, p_json_linkage5);   //
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmLinkageParamList", p_linkage_list);

				cJSON *p_ptz_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_ptz = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionType", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZActionID", 1);
					cJSON_AddNumberToObject(p_json_ptz, "PTZChannelID", 1);
					cJSON_AddItemToArray(p_ptz_list, p_json_ptz);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "PTZActionParamList", p_ptz_list);

				cJSON *p_out_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_out = cJSON_CreateObject();
					cJSON_AddStringToObject(p_json_out, "DeviceId", "");
					cJSON_AddNumberToObject(p_json_out, "AlarmOutId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmOutFlag", 1);
					cJSON_AddNumberToObject(p_json_out, "EventTypeId", 1);
					cJSON_AddNumberToObject(p_json_out, "AlarmTime", 1);
					cJSON_AddItemToArray(p_out_list, p_json_out);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "AlarmOutActionList", p_out_list);

				cJSON *p_record_list = cJSON_CreateArray();
				for (int j = 0;j<0;j++)
				{
					cJSON *p_json_record = cJSON_CreateObject();
					cJSON_AddNumberToObject(p_json_record, "PreRecordFlag", 1);
					cJSON_AddNumberToObject(p_json_record, "DelayRecordTime", 1);
					cJSON_AddItemToArray(p_record_list, p_json_record);
				}
				cJSON_AddItemToObject(p_IntelligentEvent, "RecordActionParamList", p_record_list);
			}
			cJSON_AddItemToObject(p_item, "IntelligentEvent", p_IntelligentEvent);

			cJSON *p_proper_list = cJSON_CreateArray();
			for (int j = 0;j<1;j++)
			{
				cJSON *p_json_region = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_json_region, "Sensitivity", 5);
				cJSON_AddBoolToObject(p_json_region, "TargetTypeConstrain", 0);//
				cJSON_AddNumberToObject(p_json_region, "TargetType", 0);
				cJSON_AddBoolToObject(p_json_region, "TargetSizeConstrain", 0);//
				cJSON_AddNumberToObject(p_json_region, "MinTargetSize", 1111);
				cJSON_AddNumberToObject(p_json_region, "MaxTargetSize", 9999);
				cJSON *p_area_list = cJSON_CreateArray();
				cJSON* p_item_area1 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area1, "Xval", 0);
				cJSON_AddNumberToObject(p_item_area1, "Yval", 0);
				cJSON_AddItemToArray(p_area_list, p_item_area1);
				cJSON* p_item_area2 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area2, "Xval", 0);
				cJSON_AddNumberToObject(p_item_area2, "Yval", 99.5);
				cJSON_AddItemToArray(p_area_list, p_item_area2);
				cJSON* p_item_area3 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area3, "Xval", 99.5);
				cJSON_AddNumberToObject(p_item_area3, "Yval", 99.5);
				cJSON_AddItemToArray(p_area_list, p_item_area3);
				cJSON* p_item_area4 = cJSON_CreateObject();
				cJSON_AddNumberToObject(p_item_area4, "Xval", 99.5);
				cJSON_AddNumberToObject(p_item_area4, "Yval", 0);
				cJSON_AddItemToArray(p_area_list, p_item_area4);
				cJSON_AddItemToObject(p_json_region, "SNPoint", p_area_list);

				cJSON_AddItemToArray(p_proper_list, p_json_region);
			}
			cJSON_AddItemToObject(p_item, "PerimeterRegionParamList", p_proper_list);

			cJSON_AddItemToArray(p_root, p_item);
		}
		cJSON_AddItemToObject(p_json_root, "PerimeterParamList", p_root);
		p_param = cJSON_PrintUnformatted(p_json_root);
		cJSON_Delete(p_json_root);
		ret = sdks_set_ia_perimeter_param(m_handle, -1, p_param);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 16:
	{
		ret = sdks_get_ia_version(m_handle, -1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 17:
	{
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON_AddStringToObject(p_json_root, "DeviceId", "");//307807A7F03D3DF
		cJSON_AddNumberToObject(p_json_root, "ChannelId", 1);
		cJSON_AddNumberToObject(p_json_root, "SelectMode", 2);
		cJSON_AddNumberToObject(p_json_root, "RecordMode", 4);
		cJSON_AddNumberToObject(p_json_root, "MajorType", -1);
		cJSON_AddNumberToObject(p_json_root, "MinorType", -1);
		cJSON_AddNumberToObject(p_json_root, "Precision", 0);
		cJSON_AddNumberToObject(p_json_root, "RecordSegmentInterval", 0);
		cJSON_AddNumberToObject(p_json_root, "Type", 4);  //
		cJSON_AddStringToObject(p_json_root, "BeginTime", "2019-10-06 00:00:00:00");
		cJSON_AddStringToObject(p_json_root, "EndTime", "2019-10-22 00:00:00:00");

		p_param = cJSON_PrintUnformatted(p_json_root);
		cJSON_Delete(p_json_root);
		ret = sdks_get_device_log(m_handle, p_param, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}

	case 19:
	{
#if 0
		ret = sdks_dev_get_language_cap(m_handle, 1, &p_set_json);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_get_nw_cap(m_handle, 1, &p_set_json);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_get_ptz_cap(m_handle, 1, &p_set_json);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_get_osd_cap(m_handle, 1, &p_set_json);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_get_time_zone_cap(m_handle, 1, 1, &p_set_json);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_get_video_cap(m_handle, 1, &p_set_json);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_json_get_audio_cap(m_handle, &p_set_json);
		if (ret != 0)
		{
			return -1;
		}
#endif
		ret = sdks_dev_json_get_hw_cap(m_handle, &p_set_json);
		if (ret != 0)
		{
			//return -1;
		}
		printf("ret = %d ,cap = %s \n",ret,p_set_json);
		ret = sdks_dev_json_get_sw_cap(m_handle, &p_set_json);
		if (ret != 0)
		{
			return -1;
		}

		break;
	}
	case 20:
	{
		ret = sdks_dev_get_dev_language(m_handle, 1, &p_set_json);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_set_dev_language(m_handle, 1, 1);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_json_get_dev_time(m_handle, &p_set_json);
		if (ret != 0)
		{
			return -1;
		}
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_json_root, "Year", 2018);
		cJSON_AddNumberToObject(p_json_root, "Month", 6);
		cJSON_AddNumberToObject(p_json_root, "Day", 6);
		cJSON_AddNumberToObject(p_json_root, "Hour", 6);
		cJSON_AddNumberToObject(p_json_root, "Minute", 6);
		cJSON_AddNumberToObject(p_json_root, "Second", 6);
		p_result = cJSON_PrintUnformatted(p_json_root);
		cJSON_Delete(p_json_root);
		ret = sdks_dev_json_set_dev_time(m_handle, p_result);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 21:
	{
		/*ret = sdks_dev_get_chn_info(m_handle, &p_set_json);
		if (ret != 0)
		{
		return -1;
		}*/
		ret = sdks_get_dev_time_zone(m_handle, &p_set_json);
		if (ret != 0)
		{
			return -1;
		}
		cJSON *p_json_zone = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_json_zone, "TimeZone", 210);
		cJSON_AddNumberToObject(p_json_zone, "DSTOpenFlag", 1);
		cJSON_AddNumberToObject(p_json_zone, "DSTOffset", 1);
		cJSON_AddNumberToObject(p_json_zone, "BeginMonth", 1);
		cJSON_AddNumberToObject(p_json_zone, "BeginWeekly", 1);
		cJSON_AddNumberToObject(p_json_zone, "BeginWeekDays", 1);
		cJSON_AddNumberToObject(p_json_zone, "BeginTime", 1);
		cJSON_AddNumberToObject(p_json_zone, "EndMonth", 2);
		cJSON_AddNumberToObject(p_json_zone, "EndWeekly", 2);
		cJSON_AddNumberToObject(p_json_zone, "EndWeekDays", 2);
		cJSON_AddNumberToObject(p_json_zone, "EndTime", 2);
		p_result = cJSON_PrintUnformatted(p_json_zone);
		cJSON_Delete(p_json_zone);
		ret = sdks_set_dev_time_zone(m_handle, p_result);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_get_p2p_para(m_handle, 1, &p_set_json);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_get_security_para(m_handle, 1, &p_set_json);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_set_security_para(m_handle, 1, 0);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_get_dev_id(m_handle, 1, &p_set_json);
		if (ret != 0)
		{
			return -1;
		}
		cJSON *p_json = cJSON_CreateObject();
		cJSON_AddStringToObject(p_json, "dev_id", "789asd");
		p_result = cJSON_PrintUnformatted(p_json);
		cJSON_Delete(p_json);
		ret = sdks_dev_set_dev_id(m_handle, 1, p_result);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_json_get_general_info(m_handle, &p_set_json);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_json_get_dev_name(m_handle, &p_set_json);
		if (ret != 0)
		{
			return -1;
		}
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON_AddStringToObject(p_json_root, "Name", "66666");
		p_result = cJSON_PrintUnformatted(p_json_root);
		cJSON_Delete(p_json_root);
		ret = sdks_dev_json_set_dev_name(m_handle, p_result);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 22:
	{
		ret = sdks_dev_json_get_dev_port(m_handle, &p_set_json);
		if (ret != 0)
		{
			return -1;
		}
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_json_root, "ControlPort", 30001);
		cJSON_AddNumberToObject(p_json_root, "TCPAVPort", 30001);
		cJSON_AddNumberToObject(p_json_root, "RTSPPort", 554);
		cJSON_AddNumberToObject(p_json_root, "RTPPort", 555);
		cJSON_AddNumberToObject(p_json_root, "RTCPPort", 556);
		cJSON_AddNumberToObject(p_json_root, "RegisterPort", 30005);
		cJSON_AddNumberToObject(p_json_root, "HttpPort", 80);
		cJSON_AddNumberToObject(p_json_root, "ReservePort1", 8080);
		cJSON_AddNumberToObject(p_json_root, "ReservePort2", 8081);
		cJSON_AddNumberToObject(p_json_root, "ReservePort3", 8082);
		cJSON_AddNumberToObject(p_json_root, "ReservePort4", 8083);
		cJSON_AddNumberToObject(p_json_root, "SslControlPort", 0);
		p_result = cJSON_PrintUnformatted(p_json_root);
		cJSON_Delete(p_json_root);
		ret = sdks_dev_json_set_dev_port(m_handle, p_result);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 23:
	{
		ret = sdks_dev_json_get_dev_ntp(m_handle, &p_set_json);
		if (ret != 0)
		{
			return -1;
		}
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON_AddStringToObject(p_json_root, "ip", "192.168.0.121");
		cJSON_AddNumberToObject(p_json_root, "port", 30002);
		cJSON_AddNumberToObject(p_json_root, "enable", 0);
		cJSON_AddNumberToObject(p_json_root, "proto_ver", 1);
		cJSON_AddNumberToObject(p_json_root, "time", 1);
		p_result = cJSON_PrintUnformatted(p_json_root);
		cJSON_Delete(p_json_root);
		ret = sdks_dev_json_set_dev_ntp(m_handle, p_result);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}

	case 24:
	{
		//ret = sdks_dev_get_ptz_req(m_handle, 1, &p_result);
		ret = sdks_dev_get_ptz_configue(m_handle, 1, 6, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_set_ptz_speed(m_handle, 1, 48);
		if (ret != 0)
		{
			return -1;
		}
		/*ret = sdks_dev_get_ptz_timer(m_handle, 1, &p_result);
		if (ret != 0)
		{
		return -1;
		}
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON *p_json_list = cJSON_CreateArray();
		for (int i=0;i<1;i++)
		{
		cJSON *p_json_timer = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_json_timer, "ChannelId", 1);
		cJSON_AddBoolToObject(p_json_timer, "EnableFlag", 1);
		cJSON_AddNumberToObject(p_json_timer, "TimerMode", 1);
		cJSON *p_json_info = cJSON_CreateObject();
		{
		cJSON_AddNumberToObject(p_json_info, "TimeZone", 9);
		cJSON_AddNumberToObject(p_json_info, "DaylightSavingTime", 9);
		cJSON_AddNumberToObject(p_json_info, "Year", 2019);
		cJSON_AddNumberToObject(p_json_info, "Month", 9);
		cJSON_AddNumberToObject(p_json_info, "Day", 9);
		cJSON_AddNumberToObject(p_json_info, "DayOfWeek", 6);
		cJSON_AddNumberToObject(p_json_info, "Hour", 6);
		cJSON_AddNumberToObject(p_json_info, "Minute", 6);
		cJSON_AddNumberToObject(p_json_info, "Second", 6);
		cJSON_AddNumberToObject(p_json_info, "Milliseconds", 66);
		cJSON_AddItemToObject(p_json_timer, "TimerDate", p_json_info);
		}
		cJSON *p_segment_list = cJSON_CreateArray();
		for (int i = 0;i<1;i++)
		{
		cJSON *p_json_preset = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_json_preset, "BeginTime", 0);
		cJSON_AddNumberToObject(p_json_preset, "EndTime",86400);
		cJSON_AddStringToObject(p_json_preset, "PTZOperation", "(16,1)");
		cJSON_AddItemToArray(p_segment_list, p_json_preset);
		}
		cJSON_AddItemToObject(p_json_timer, "TimeSegmentList", p_segment_list);
		cJSON_AddItemToArray(p_json_list, p_json_timer);
		}
		cJSON_AddItemToObject(p_json_root, "PTZTimer", p_json_list);
		p_set_json = cJSON_PrintUnformatted(p_json_root);
		cJSON_Delete(p_json_root);
		ret = sdks_dev_set_ptz_timer(m_handle, 1, p_set_json);
		if (ret != 0)
		{
		return -1;
		}*/

		break;
	}
	case 25:
	{
		ret = sdks_dev_open_ptz(m_handle);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_ptz_brush(m_handle, 1, 85, 0, 0);
		
		/*ret = sdks_dev_ptz_brush(m_handle, 1, 35,0,0);
	
		ret = sdks_dev_ptz_brush(m_handle, 1, 63, 0, 0);
		*/

		/*ret = sdks_dev_ptz_light(m_handle, 1, 40);
		
		ret = sdks_dev_ptz_light(m_handle, 1, 41);
		*/

		ret = sdks_dev_ptz_defog(m_handle, 1, 120);
		
		ret = sdks_dev_ptz_defog(m_handle, 1, 121);
	

		ret = sdks_dev_close_ptz(m_handle);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 26:
	{
		ret = sdks_dev_open_ptz(m_handle);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_ptz_keeper(m_handle, 1, 38, 2, 0, 0, 0);
		
		ret = sdks_dev_ptz_keeper(m_handle, 1, 37, 0, 1, 1, 10);
		
		ret = sdks_dev_ptz_keeper(m_handle, 1, 38, 0, 0, 0, 0);
		
		ret = sdks_dev_close_ptz(m_handle);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 27:
	{
		ret = sdks_dev_open_ptz(m_handle);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_ptz_zoom(m_handle, 1, 9, 32);
	
		ret = sdks_dev_ptz_zoom(m_handle, 1, 10, 32);
	
		ret = sdks_dev_ptz_focus(m_handle, 1, 11);
		
		ret = sdks_dev_ptz_focus(m_handle, 1, 12);
		
		ret = sdks_dev_ptz_focus(m_handle, 1, 24);
	
		ret = sdks_dev_ptz_iris(m_handle, 1, 13);
		
		ret = sdks_dev_ptz_iris(m_handle, 1, 14);
	
		ret = sdks_dev_close_ptz(m_handle);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 28:
	{
		ret = sdks_dev_open_ptz(m_handle);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_ptz_rotate(m_handle, 1, 1, 32);
	
		ret = sdks_dev_ptz_rotate(m_handle, 1, 2, 32);
	
		ret = sdks_dev_ptz_rotate(m_handle, 1, 3, 32);
	
		ret = sdks_dev_ptz_rotate(m_handle, 1, 4, 32);
	
		ret = sdks_dev_ptz_rotate(m_handle, 1, 5, 32);
	
		ret = sdks_dev_ptz_rotate(m_handle, 1, 6, 32);
	
		ret = sdks_dev_ptz_rotate(m_handle, 1, 7, 32);
	
		ret = sdks_dev_ptz_rotate(m_handle, 1, 8, 32);
		
		ret = sdks_dev_ptz_rotate(m_handle, 1, 65, 32);
	
		ret = sdks_dev_ptz_rotate(m_handle, 1, 29, 0);
	
		ret = sdks_dev_ptz_rotate(m_handle, 3, 0, 0);
		ret = sdks_dev_close_ptz(m_handle);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 29:
	{
		ret = sdks_dev_open_ptz(m_handle);
		printf("**  open ptz ret = %d\n",ret);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_ptz_preset(m_handle, 1, 1, 16);
		printf("add ret = %d\n",ret);
		ret = sdks_dev_ptz_preset(m_handle, 1, 2, 16);
		printf("call ret = %d\n",ret);
		ret = sdks_dev_ptz_preset(m_handle, 1, 3, 16);
		printf("delet ret = %d\n",ret);
		ret = sdks_dev_close_ptz(m_handle);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 30:
	{
		ret = sdks_dev_open_ptz(m_handle);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_ptz_track(m_handle, 1, 3, 26);
	
		ret = sdks_dev_ptz_track(m_handle, 1, 3, 27);
	
		ret = sdks_dev_ptz_track(m_handle, 1, 3, 28);
	
		ret = sdks_dev_ptz_track(m_handle, 1, 3, 45);
	
		ret = sdks_dev_close_ptz(m_handle);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 31:
	{
		ret = sdks_dev_open_ptz(m_handle);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_ptz_scan(m_handle, 1, 3, 22);
		
		ret = sdks_dev_ptz_scan(m_handle, 1, 3, 23);
		
		ret = sdks_dev_ptz_scan(m_handle, 1, 3, 21);
		
		ret = sdks_dev_ptz_scan(m_handle, 1, 3, 44);
	
		ret = sdks_dev_close_ptz(m_handle);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 32:
	{
		ret = sdks_dev_open_ptz(m_handle);
		if (ret != 0)
		{
			return -1;
		}
		ret = sdks_dev_ptz_tour(m_handle, 1, 3, 31, 0, 0);
		ret = sdks_dev_ptz_tour(m_handle, 1, 3, 32, 32, 3);
	
		ret = sdks_dev_ptz_tour(m_handle, 1, 3, 33, 0, 0);
		ret = sdks_dev_ptz_tour(m_handle, 1, 3, 34, 0, 0);

		ret = sdks_dev_ptz_tour(m_handle, 1, 3, 35, 0, 0);
	
		ret = sdks_dev_ptz_tour(m_handle, 1, 3, 200, 0, 0);
	
		ret = sdks_dev_ptz_tour(m_handle, 1, 3, 36, 0, 0);
		
		ret = sdks_dev_close_ptz(m_handle);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 33:
	{
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_json_root, "Value", 0);
		cJSON *p_root = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_root, "OperatorType", 1);
		cJSON_AddNumberToObject(p_root, "CameraID", 1);
		cJSON_AddNumberToObject(p_root, "PTZID", 0);
		cJSON_AddItemToObject(p_json_root, "OperatorTypeList", p_root);
		cJSON_AddStringToObject(p_json_root, "FileName", "/tmp/LprList.tar");
		p_result = cJSON_PrintUnformatted(p_json_root);
		cJSON_Delete(p_json_root);
		ret = sdks_lpr_ipfilter_list_file_download(m_handle, 1, p_result);
		if (ret != 0)
		{
			return -1;
		}

		////FILE* fp;
		////int size = 0;
		////fp = fopen("./BlaceList.csv", "r");
		//////fp = fopen("./demo.jpg", "r");
		////if (fp == NULL) // 
		////	return -1;
		////fseek(fp, 0, SEEK_END);//
		////size = ftell(fp);//
		////fseek(fp, 0, SEEK_SET);
		////char *buffer = (char *)malloc(size + 4);
		////memset(buffer, 0, size);
		////fread(buffer, 1, size, fp);
		////
		////cJSON *p_json_root = cJSON_CreateObject();	
		////cJSON_AddBoolToObject(p_json_root, "FileEnd", 0);
		////cJSON *p_root = cJSON_CreateObject();
		////cJSON_AddNumberToObject(p_root, "DataLength", size);
		////cJSON_AddStringToObject(p_root, "Data", buffer);
		////cJSON_AddItemToObject(p_json_root, "DataBuffer", p_root);
		////p_result = cJSON_PrintUnformatted(p_json_root);
		////cJSON_Delete(p_json_root);
		////ret = sdks_lpr_ipfilter_list_file_upload(m_handle, 1, p_result);
		////if (ret != 0)
		////{
		////	return -1;
		////}
		break;
	}

	case 35:
	{
		cJSON *p_json_root1 = cJSON_CreateObject();
		cJSON_AddStringToObject(p_json_root1, "Number", "J333");
		p_result = cJSON_PrintUnformatted(p_json_root1);
		cJSON_Delete(p_json_root1);
		ret = sdks_lpr_ipfilter_list_search_open(m_handle, 1, p_result, &p_set_json);
		if (ret != 0)
		{
			return -1;
		}
		p_result = NULL;
		cJSON *p_json_root2 = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_json_root2, "QueryHandle", 12);
		cJSON_AddNumberToObject(p_json_root2, "BeginIndex", 0);
		cJSON_AddNumberToObject(p_json_root2, "EndIndex", 100);
		p_result = cJSON_PrintUnformatted(p_json_root2);
		cJSON_Delete(p_json_root2);
		ret = sdks_lpr_ipfilter_list_search_get(m_handle, 1, p_result, &p_set_json);
		if (ret != 0)
		{
			return -1;
		}
		p_result = NULL;
		cJSON *p_json_root3 = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_json_root3, "QueryHandle", 12);
		p_result = cJSON_PrintUnformatted(p_json_root3);
		cJSON_Delete(p_json_root3);
		ret = sdks_lpr_ipfilter_list_search_close(m_handle, 1, p_result);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 36:
	{
		ret = sdks_get_lpr_ipfilter_list_num(m_handle, 1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		p_result = NULL;
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_json_root, "BeginIndex", 0);
		cJSON_AddNumberToObject(p_json_root, "EndIndex", 10);
		p_result = cJSON_PrintUnformatted(p_json_root);
		cJSON_Delete(p_json_root);
		ret = sdks_get_lpr_ipfilter_list(m_handle, 1, p_result, &p_set_json);
		if (ret != 0)
		{
			return -1;
		}
		break;
	}
	case 37:
	{
		cJSON *p_json_root1 = cJSON_CreateObject();
		cJSON *p_time_list1 = cJSON_CreateArray();
		for (int i = 0;i<1;i++)
		{
			cJSON *p_json_time = cJSON_CreateObject();
			cJSON_AddStringToObject(p_json_time, "Text", "BCDS6");
			cJSON_AddNumberToObject(p_json_time, "Type", 1);
			cJSON_AddNumberToObject(p_json_time, "StartTime", 1565539200); //2019-08-12 00:00:00
			cJSON_AddNumberToObject(p_json_time, "EndTime", 1568082493); //2019-09-05 12:00:49
			cJSON_AddItemToArray(p_time_list1, p_json_time);
		}
		cJSON_AddItemToObject(p_json_root1, "LprIpfilterList", p_time_list1);
		p_result = cJSON_PrintUnformatted(p_json_root1);
		ret = sdks_lpr_ipfilter_list_add(m_handle, 1, p_result);
		if (ret != 0)
		{
			return -1;
		}
		/*ret = sdks_lpr_ipfilter_list_delete(m_handle, 1, p_result);
		if (ret != 0)
		{
		LOG_INFO("error : %%d \n", ret);
		return -1;
		}*/
		/*ret = sdks_lpr_ipfilter_list_add(m_handle, 1, p_result);
		if (ret != 0)
		{
		LOG_INFO("error : %%d \n", ret);
		return -1;
		}*/
		cJSON_Delete(p_json_root1);

		cJSON *p_json_root2 = cJSON_CreateObject();
		cJSON *p_time_list2 = cJSON_CreateArray();
		for (int i = 0;i<1;i++)
		{
			cJSON *p_json_time = cJSON_CreateObject();
			cJSON_AddStringToObject(p_json_time, "Text", "ad666");
			cJSON_AddNumberToObject(p_json_time, "Type", 0);
			cJSON_AddNumberToObject(p_json_time, "StartTime", 1565539200);
			cJSON_AddNumberToObject(p_json_time, "EndTime", 1568082493);
			cJSON_AddItemToArray(p_time_list2, p_json_time);
		}
		cJSON_AddItemToObject(p_json_root2, "ListOld", p_time_list2);
		cJSON *p_time_list3 = cJSON_CreateArray();
		for (int i = 0;i<1;i++)
		{
			cJSON *p_json_time = cJSON_CreateObject();
			cJSON_AddStringToObject(p_json_time, "Text", "ABCDEFG");
			cJSON_AddNumberToObject(p_json_time, "Type", 1);
			cJSON_AddNumberToObject(p_json_time, "StartTime", 1565404093);
			cJSON_AddNumberToObject(p_json_time, "EndTime", 1568946493);
			cJSON_AddItemToArray(p_time_list3, p_json_time);
		}
		cJSON_AddItemToObject(p_json_root2, "ListNew", p_time_list3);
		p_result = cJSON_PrintUnformatted(p_json_root2);
		ret = sdks_lpr_ipfilter_list_modify(m_handle, 1, p_result);
		if (ret != 0)
		{
			return -1;
		}
		cJSON_Delete(p_json_root2);
		break;
	}
	case 38:
	{
		ret = sdks_get_lpr_link_param(m_handle, 1, &p_set_json);
		if (ret != 0)
		{
			return -1;
		}
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON *p_root = cJSON_CreateObject();
		cJSON_AddBoolToObject(p_root, "BlackListFTPUpload", 1);
		cJSON_AddBoolToObject(p_root, "BlackListOpenBarrier", 1);
		cJSON_AddBoolToObject(p_root, "BlackListSMTP", 1);
		cJSON_AddBoolToObject(p_root, "WhilteListFTPUpload", 0);
		cJSON_AddBoolToObject(p_root, "WhilteListOpenBarrier", 0);
		cJSON_AddBoolToObject(p_root, "WhilteListSMTP", 0);
		cJSON_AddBoolToObject(p_root, "NoListFTPUpload", 1);
		cJSON_AddBoolToObject(p_root, "NoListOpenBarrier", 1);
		cJSON_AddBoolToObject(p_root, "NoListSMTP", 1);
		cJSON_AddBoolToObject(p_root, "SnapshotFTPUpload", 0);
		cJSON_AddBoolToObject(p_root, "OpenBarrierLevel", 0);
		cJSON_AddNumberToObject(p_root, "OpenBarrierDuration", 22);
		cJSON_AddBoolToObject(p_root, "LprOSD", 0);
		cJSON_AddNumberToObject(p_root, "LprOSDDuration", 33);
		cJSON_AddItemToObject(p_json_root, "LprLinkParam", p_root);
		p_result = cJSON_PrintUnformatted(p_json_root);
		cJSON_Delete(p_json_root);
		ret = sdks_set_lpr_link_param(m_handle, 1, p_result);
		if (ret != 0)
		{
			return -1;
		}
	}
	break;
	case 39:
	{
		ret = sdks_get_lpr_detect_param(m_handle, 1, &p_set_json);
		if (ret != 0)
		{
			return -1;
		}
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON *p_root = cJSON_CreateObject();
		cJSON_AddBoolToObject(p_root, "PlateEnable", 1);
		cJSON_AddBoolToObject(p_root, "VehicleEnable", 1);
		cJSON_AddNumberToObject(p_root, "SnapPictureMode", 0);
		cJSON_AddNumberToObject(p_root, "SnapPictureNum", 1);
		cJSON_AddNumberToObject(p_root, "ConsumePictrueMode", 3);
		cJSON_AddBoolToObject(p_root, "ShowObjectEnable", 1);
		cJSON_AddBoolToObject(p_root, "ShowAreaEnable", 0);
		cJSON_AddBoolToObject(p_root, "FtpUploadEnable", 1);
		cJSON_AddBoolToObject(p_root, "FtpUploadFullViewEnable", 1);
		cJSON_AddNumberToObject(p_root, "UploadInterval", 5);
		cJSON_AddNumberToObject(p_root, "Reliability", 66);
		cJSON_AddNumberToObject(p_root, "MinPixelWidth", 77);
		cJSON_AddNumberToObject(p_root, "MaxPixelWidth", 88);
		cJSON_AddNumberToObject(p_root, "PictureQuality", 99);
		cJSON_AddBoolToObject(p_root, "LYFlag", 1);
		cJSON *p_time_list = cJSON_CreateArray();
		cJSON *p_json_time = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_json_time, "WeekDay", 3);
		cJSON_AddNumberToObject(p_json_time, "StartTime", 111);
		cJSON_AddNumberToObject(p_json_time, "EndTime", 888);
		cJSON_AddItemToArray(p_time_list, p_json_time);
		cJSON_AddItemToObject(p_root, "ScheduleTimeList", p_time_list);
		cJSON *p_area_list = cJSON_CreateArray();
		cJSON *p_json_point = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_json_point, "Xval", 77.77000);
		cJSON_AddNumberToObject(p_json_point, "Yval", 88.88);
		cJSON_AddItemToArray(p_area_list, p_json_point);
		cJSON_AddItemToObject(p_root, "PolygonAreaList", p_area_list);
		cJSON_AddItemToObject(p_json_root, "VehiclePlateDetectParam", p_root);
		p_result = cJSON_PrintUnformatted(p_json_root);
		cJSON_Delete(p_json_root);
		ret = sdks_set_lpr_detect_param(m_handle, 1, p_result);
		if (ret != 0)
		{
			return -1;
		}
	}
	break;
	case 40:
	{
		int g_stream_id = sdks_dev_face_detect_start(m_handle, 1, 1, 4, detect_face_cb, NULL);
	}
	break;
# if 0
	case 41:   //
	{
		ret = sdks_start_database(m_handle, facebase_cb, NULL);
		if (ret != 0)
		{
			return -1;
		}
		FILE* fp;
		int size = 0;
		fp = fopen("./demo.jpg", "r");
		if (fp == NULL)
			return -1;
		fseek(fp, 0, SEEK_END);
		size = ftell(fp);
		fseek(fp, 0, SEEK_SET);
		char *buffer = (char *)malloc(size + 4);
		memset(buffer, 0, size);
		fread(buffer, 1, size, fp);

		cJSON *p_json_root = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_json_root, "channel_num", 1);
		cJSON *p_json_data = cJSON_CreateArray();
		for (int i = 0;i<1;i++)
		{
			cJSON* p_item = cJSON_CreateObject();
			cJSON_AddNumberToObject(p_item, "chn", 1);
			cJSON_AddItemToArray(p_json_data, p_item);
		}
		cJSON_AddItemToObject(p_json_root, "channel_list", p_json_data);
		cJSON_AddNumberToObject(p_json_root, "s_time", 1565539200); //2019-08-12 00:00:00
		cJSON_AddNumberToObject(p_json_root, "e_time", 1566144000); //2019-08-19 00:00:00
		cJSON_AddNumberToObject(p_json_root, "search_type", 0);
		cJSON_AddNumberToObject(p_json_root, "similarity", 80);
		cJSON_AddStringToObject(p_json_root, "id", "");
		cJSON_AddStringToObject(p_json_root, "name", "");
		cJSON_AddNumberToObject(p_json_root, "gender", 3);
		p_set_json = cJSON_PrintUnformatted(p_json_root);
		ret = sdks_dev_get_database_index(m_handle, 1, buffer, size, p_set_json, &p_result);
		if (ret != 0)
		{
			return -1;
		}

		fclose(fp);//

		ret = sdks_dev_get_database_info(m_handle, p_result);
		if (ret != 0)
		{
			return -1;
		}
		free(p_set_json);

		/*ret = sdks_stop_database(m_handle);
		if (ret != 0)
		{
		return -1;
		}*/
	}
	break;
	case 42:
	{
		ret = sdks_dev_face_get_group_num(m_handle, 1, &p_result);
		if (ret != 0)
		{
			return -1;
		}
		cJSON *p_json_root = cJSON_CreateObject();
		cJSON_AddStringToObject(p_json_root, "Group", "cxy");
		cJSON_AddNumberToObject(p_json_root, "MemberNum", 18);
		cJSON_AddStringToObject(p_json_root, "StartTime", "1569772800");
		cJSON_AddStringToObject(p_json_root, "EndTime", "1570032000");
		cJSON_AddNumberToObject(p_json_root, "Type", 1);
		p_set_json = cJSON_PrintUnformatted(p_json_root);
		char path[32] = {0};
		strcpy(path, "./json.txt");
		ret = sdks_dev_face_get_attendance_data(m_handle, 1, p_set_json, path);
		if (ret != 0)
		{
			return -1;
		}


		//cJSON *p_json_root1 = cJSON_CreateObject();
		//cJSON *p_json_data1 = cJSON_CreateArray();
		//for (int i = 0;i<1;i++)
		//{
		//	cJSON* p_item = cJSON_CreateObject();
		//	cJSON_AddStringToObject(p_item, "Name", "cxy");
		//	cJSON_AddItemToArray(p_json_data1, p_item);
		//}
		//cJSON_AddItemToObject(p_json_root1, "AttendanceGroupList", p_json_data1);
		//cJSON_AddNumberToObject(p_json_root1, "TotalNum", 18);
		//cJSON_AddNumberToObject(p_json_root1, "PerPage", 20);
		//cJSON_AddNumberToObject(p_json_root1, "Page", 1);
		//p_set_json = cJSON_PrintUnformatted(p_json_root1);
		//ret = sdks_dev_face_get_member(m_handle, 1, p_set_json, &p_result);
		//if (ret != 0)
		//{
		//	LOG_INFO("error : %%d \n", ret);
		//	return -1;
		//}
		//if (p_result != NULL)
		//{
		//	free(p_set_json);
		//	p_result = NULL;
		//}
		//cJSON_Delete(p_json_root1);

		//cJSON *p_json_root2 = cJSON_CreateObject();
		//cJSON_AddStringToObject(p_json_root2, "Key", "[325]");
		//cJSON_AddStringToObject(p_json_root2, "StartTime", "1569772800");
		//cJSON_AddStringToObject(p_json_root2, "EndTime", "1570032000");
		//cJSON_AddNumberToObject(p_json_root2, "Type", 1);
		//p_set_json = cJSON_PrintUnformatted(p_json_root2);
		//ret = sdks_dev_face_check_data(m_handle, 1, p_set_json, &p_result);
		//if (ret != 0)
		//{
		//	LOG_INFO("error : %%d \n", ret);
		//	return -1;
		//}
		//if (p_result != NULL)
		//{
		//	free(p_set_json);
		//	p_result = NULL;
		//}
		//cJSON_Delete(p_json_root2);

		//cJSON *p_json_root3 = cJSON_CreateObject();

		//cJSON_AddNumberToObject(p_json_root3, "TotalNum", 100);
		//cJSON_AddNumberToObject(p_json_root3, "PerPage", 20);
		//cJSON_AddNumberToObject(p_json_root3, "Page", 1);
		//p_set_json = cJSON_PrintUnformatted(p_json_root3);
		//ret = sdks_dev_face_get_statis(m_handle, 1, p_set_json, &p_result);
		//if (ret != 0)
		//{
		//	LOG_INFO("error : %%d \n", ret);
		//	return -1;
		//}
		//if (p_result != NULL)
		//{
		//	free(p_set_json);
		//	p_result = NULL;
		//}
		//cJSON_Delete(p_json_root3);
	}
	break;
#endif
	case 43:
	{
		ret = sdks_dev_open_ptz(m_handle);
		if (ret != 0)
		{
			return -1;
		}
		printf("return ret ptz_start:%d \n",ret);
		ret = sdks_dev_get_ptz_postion(m_handle,1,&p_result);
		printf("return ret ptz:%d \n",ret);
		// 
		char  *param = NULL;
		char* pp_result = NULL;
		cJSON* p_root = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_root, "chn_id", 1);
		cJSON_AddNumberToObject(p_root, "area_oper_type", 3);
		param = cJSON_PrintUnformatted(p_root);
		int ret = sdks_get_thermal_area_feature_temperature(m_handle, param, &pp_result);
		printf("return ret:%d \n",ret);
		printf("return pp_result:%s \n",pp_result);
		cJSON_Delete(p_root);
		break;
	}

	default:
		break;
	}
	getchar();
	sdks_dev_conn_close(m_handle);
	sdks_dev_quit();
	return 0 ;
}
